/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.pricing;

import com.twilio.sdk.TwilioPricingClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import com.twilio.sdk.resource.instance.pricing.NumberType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VoiceCountry
extends NextGenInstanceResource<TwilioPricingClient> {
    public VoiceCountry(TwilioPricingClient client) {
        super(client);
    }

    public VoiceCountry(TwilioPricingClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public VoiceCountry(TwilioPricingClient client, String isoCountry) {
        super(client);
        if (isoCountry == null || "".equals(isoCountry)) {
            throw new IllegalArgumentException("The isoCountry for a VoiceCountry cannot be null");
        }
        this.setProperty("iso_country", isoCountry);
    }

    public String getCountry() {
        return this.getProperty("country");
    }

    public String getIsoCountry() {
        return this.getProperty("iso_country");
    }

    public String getPriceUnit() {
        return this.getProperty("price_unit");
    }

    public List<InboundCallPrice> getInboundCallPrices() {
        List priceData = (List)this.getObject("inbound_call_prices");
        ArrayList<InboundCallPrice> prices = new ArrayList<InboundCallPrice>();
        for (Map p : priceData) {
            prices.add(new InboundCallPrice(NumberType.valueOf(((String)p.get("number_type")).toUpperCase()), new BigDecimal((String)p.get("base_price")), new BigDecimal((String)p.get("current_price"))));
        }
        return prices;
    }

    public List<OutboundPrefixPrice> getOutboundPrefixPrices() {
        List priceData = (List)this.getObject("outbound_prefix_prices");
        ArrayList<OutboundPrefixPrice> prices = new ArrayList<OutboundPrefixPrice>();
        for (Map p : priceData) {
            prices.add(new OutboundPrefixPrice((String)p.get("friendly_name"), new BigDecimal((String)p.get("base_price")), new BigDecimal((String)p.get("current_price")), (List)p.get("prefix_list")));
        }
        return prices;
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Voice/Countries/" + this.getIsoCountry();
    }

    public class InboundCallPrice {
        private NumberType numberType;
        private BigDecimal basePrice;
        private BigDecimal currentPrice;

        public InboundCallPrice(NumberType numberType, BigDecimal basePrice, BigDecimal currentPrice) {
            this.numberType = numberType;
            this.basePrice = basePrice;
            this.currentPrice = currentPrice;
        }

        public NumberType getNumberType() {
            return this.numberType;
        }

        public BigDecimal getBasePrice() {
            return this.basePrice;
        }

        public BigDecimal getCurrentPrice() {
            return this.currentPrice;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InboundCallPrice that = (InboundCallPrice)o;
            if (!this.basePrice.equals(that.basePrice)) {
                return false;
            }
            if (!this.currentPrice.equals(that.currentPrice)) {
                return false;
            }
            return this.numberType == that.numberType;
        }

        public int hashCode() {
            int result = this.numberType.hashCode();
            result = 31 * result + this.basePrice.hashCode();
            result = 31 * result + this.currentPrice.hashCode();
            return result;
        }
    }

    public class OutboundPrefixPrice {
        private final String friendlyName;
        private final BigDecimal basePrice;
        private final BigDecimal currentPrice;
        private final List<String> prefixes;

        public OutboundPrefixPrice(String friendlyName, BigDecimal basePrice, BigDecimal currentPrice, List<String> prefixes) {
            this.friendlyName = friendlyName;
            this.basePrice = basePrice;
            this.currentPrice = currentPrice;
            this.prefixes = prefixes;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public BigDecimal getBasePrice() {
            return this.basePrice;
        }

        public BigDecimal getCurrentPrice() {
            return this.currentPrice;
        }

        public List<String> getPrefixes() {
            return this.prefixes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutboundPrefixPrice that = (OutboundPrefixPrice)o;
            if (!this.basePrice.equals(that.basePrice)) {
                return false;
            }
            if (!this.currentPrice.equals(that.currentPrice)) {
                return false;
            }
            if (!this.friendlyName.equals(that.friendlyName)) {
                return false;
            }
            return this.prefixes.equals(that.prefixes);
        }

        public int hashCode() {
            int result = this.friendlyName.hashCode();
            result = 31 * result + this.basePrice.hashCode();
            result = 31 * result + this.currentPrice.hashCode();
            result = 31 * result + this.prefixes.hashCode();
            return result;
        }
    }
}

