/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.InstanceResource;
import com.twilio.sdk.resource.instance.FeedbackSummaryIssue;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeedbackSummary
extends InstanceResource<TwilioRestClient> {
    public static final String ACCOUNT_SID_PROPERTY = "account_sid";
    public static final String CALL_COUNT_PROPERTY = "call_count";
    public static final String CALL_FEEDBACK_COUNT_PROPERTY = "call_feedback_count";
    public static final String END_DATE_PROPERTY = "end_date";
    public static final String INCLUDE_SUB_ACCOUNTS_PROPERTY = "include_subaccounts";
    public static final String ISSUES_PROPERTY = "issues";
    public static final String QUALITY_SCORE_AVERAGE_PROPERTY = "quality_score_average";
    public static final String QUALITY_SCORE_MEDIAN_PROPERTY = "quality_score_median";
    public static final String QUALITY_SCORE_STANDARD_DEVIATION_PROPERTY = "quality_score_standard_deviation";
    public static final String START_DATE_PROPERTY = "start_date";
    public static final String STATUS_PROPERTY = "status";
    private static final String DATE_FORMAT = "yyyy-MM-dd";

    public FeedbackSummary(TwilioRestClient client) {
        super(client);
    }

    public FeedbackSummary(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Calls/FeedbackSummary" + this.getSid() + ".json";
    }

    public String getAccountSid() {
        return this.getProperty(ACCOUNT_SID_PROPERTY);
    }

    public Integer getCallCount() {
        try {
            return (Integer)this.getObject(CALL_COUNT_PROPERTY);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Integer getCallFeedbackCount() {
        try {
            return (Integer)this.getObject(CALL_FEEDBACK_COUNT_PROPERTY);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Date getDateCreated() {
        return this.getDateProperty("date_created");
    }

    public Date getDateUpdated() {
        return this.getDateProperty("date_updated");
    }

    public Date getEndDate() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        try {
            return format.parse(this.getProperty(END_DATE_PROPERTY));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public boolean isIncludeSubAccounts() {
        return Boolean.parseBoolean(this.getProperty(INCLUDE_SUB_ACCOUNTS_PROPERTY));
    }

    public Set<FeedbackSummaryIssue> getIssues() {
        try {
            List props = (List)this.getObject(ISSUES_PROPERTY);
            HashSet<FeedbackSummaryIssue> issues = new HashSet<FeedbackSummaryIssue>();
            for (Map prop : props) {
                FeedbackSummaryIssue issueSummary = this.mapToFeedbackIssueSummary(prop);
                issues.add(issueSummary);
            }
            return Collections.unmodifiableSet(issues);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Double getQualityScoreAverage() {
        try {
            Object prop = this.getObject(QUALITY_SCORE_AVERAGE_PROPERTY);
            if (prop instanceof Integer) {
                return Double.parseDouble(prop.toString());
            }
            return (Double)prop;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Double getQualityScoreMedian() {
        try {
            Object prop = this.getObject(QUALITY_SCORE_MEDIAN_PROPERTY);
            if (prop instanceof Integer) {
                return Double.parseDouble(prop.toString());
            }
            return (Double)prop;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Double getQualityScoreStandardDeviation() {
        try {
            Object prop = this.getObject(QUALITY_SCORE_STANDARD_DEVIATION_PROPERTY);
            if (prop instanceof Integer) {
                return Double.parseDouble(prop.toString());
            }
            return (Double)prop;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Date getStartDate() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        try {
            return format.parse(this.getProperty(START_DATE_PROPERTY));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getStatus() {
        return this.getProperty(STATUS_PROPERTY);
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    protected FeedbackSummaryIssue mapToFeedbackIssueSummary(Map<String, Object> data) {
        double percentage;
        int count;
        String description;
        try {
            description = (String)data.get("description");
            count = (Integer)data.get("count");
            percentage = Double.parseDouble(((String)data.get("percentage_of_total_calls")).replace("%", ""));
        }
        catch (Exception nfe) {
            throw new IllegalStateException("A Feedback Summary Issue contained improperly formatted data.", nfe);
        }
        return new FeedbackSummaryIssue(description, count, percentage);
    }
}

