/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.list.sip;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.ListResource;
import com.twilio.sdk.resource.factory.sip.CredentialFactory;
import com.twilio.sdk.resource.instance.sip.Credential;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class CredentialList
extends ListResource<Credential>
implements CredentialFactory {
    private String requestCredentialListSid;

    public CredentialList(TwilioRestClient client) {
        super(client);
    }

    public CredentialList(TwilioRestClient client, String credentialListSid) {
        super(client);
        this.requestCredentialListSid = credentialListSid;
    }

    public CredentialList(TwilioRestClient client, Map<String, String> filters) {
        super(client, filters);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/SIP/CredentialLists/" + this.getRequestCredentialListSid() + "/Credentials.json";
    }

    @Override
    protected Credential makeNew(TwilioRestClient client, Map<String, Object> params) {
        return new Credential(client, params);
    }

    @Override
    protected String getListKey() {
        return "credentials";
    }

    public String getRequestCredentialListSid() {
        return this.requestCredentialListSid;
    }

    @Override
    public Credential create(Map<String, String> params) throws TwilioRestException {
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew(this.getClient(), (Map)response.toMap());
    }

    @Override
    public Credential create(List<NameValuePair> params) throws TwilioRestException {
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew(this.getClient(), (Map)response.toMap());
    }
}

