/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.util;

import io.ktor.util.date.DateJvmKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000f\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0010J'\u0010\u0011\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00028\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0018J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\u0015\u0010\u001a\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"Lcom/twilio/util/ExpirableCache;", "K", "V", "", "flushInterval", "", "(J)V", "lastFlushTime", "map", "", "size", "", "getSize", "()I", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "getOrPut", "getValue", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "putAll", "", "items", "", "recycle", "remove", "set", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "convo-android_release"})
@SourceDebugExtension(value={"SMAP\nExpirableCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpirableCache.kt\ncom/twilio/util/ExpirableCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class ExpirableCache<K, V> {
    private final long flushInterval;
    @NotNull
    private final Map<K, V> map;
    private long lastFlushTime;

    public ExpirableCache(long flushInterval) {
        this.flushInterval = flushInterval;
        this.map = new LinkedHashMap();
        this.lastFlushTime = DateJvmKt.getTimeMillis();
    }

    public /* synthetic */ ExpirableCache(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 60000L;
        }
        this(l);
    }

    public final int getSize() {
        this.recycle();
        return this.map.size();
    }

    @Nullable
    public final V remove(K key) {
        this.recycle();
        return this.map.remove(key);
    }

    @Nullable
    public final V get(K key) {
        this.recycle();
        return this.map.get(key);
    }

    public final void set(K key, V value) {
        this.recycle();
        this.map.put(key, value);
    }

    public final void putAll(@NotNull Map<K, ? extends V> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.recycle();
        this.map.putAll(items);
    }

    public final V getOrPut(K key, @NotNull Function0<? extends V> getValue) {
        Intrinsics.checkNotNullParameter(getValue, (String)"getValue");
        boolean $i$f$getOrPut = false;
        V v = this.get(key);
        if (v != null) {
            V it = v;
            boolean bl = false;
            return it;
        }
        Object value = getValue.invoke();
        this.map.put(key, value);
        return (V)value;
    }

    private final void recycle() {
        boolean shouldRecycle;
        boolean bl = shouldRecycle = DateJvmKt.getTimeMillis() - this.lastFlushTime >= this.flushInterval;
        if (shouldRecycle) {
            this.map.clear();
            this.lastFlushTime = DateJvmKt.getTimeMillis();
        }
    }

    public ExpirableCache() {
        this(0L, 1, null);
    }
}

