/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.conversations;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.twilio.conversations.AggregatedDeliveryReceipt;
import com.twilio.conversations.Attributes;
import com.twilio.conversations.CallbackListener;
import com.twilio.conversations.CancellationToken;
import com.twilio.conversations.Conversation;
import com.twilio.conversations.DetailedDeliveryReceipt;
import com.twilio.conversations.Media;
import com.twilio.conversations.MediaCategory;
import com.twilio.conversations.Participant;
import com.twilio.conversations.StatusListener;
import com.twilio.conversations.content.ContentData;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface Message {
    public String getSid();

    public String getAuthor();

    @Nullable
    public String getSubject();

    public String getDateCreated();

    public Date getDateCreatedAsDate();

    public String getDateUpdated();

    public Date getDateUpdatedAsDate();

    @Nullable
    public String getLastUpdatedBy();

    public String getBody();

    @Nullable
    public String getContentSid();

    public CancellationToken getContentData(@NonNull CallbackListener<ContentData> var1);

    public void updateBody(String var1, StatusListener var2);

    public String getConversationSid();

    public Conversation getConversation();

    public String getParticipantSid();

    public Participant getParticipant();

    public long getMessageIndex();

    @NonNull
    public Attributes getAttributes();

    public void setAttributes(@NonNull Attributes var1, StatusListener var2);

    public AggregatedDeliveryReceipt getAggregatedDeliveryReceipt();

    public void getDetailedDeliveryReceiptList(CallbackListener<List<DetailedDeliveryReceipt>> var1);

    @NotNull
    public List<Media> getMediaByCategories(@NonNull Set<MediaCategory> var1);

    @NotNull
    public List<Media> getAttachedMedia();

    @Nullable
    public Media getEmailBody(@NonNull String var1);

    @Nullable
    public Media getEmailBody();

    @Nullable
    public Media getEmailHistory(@NonNull String var1);

    @Nullable
    public Media getEmailHistory();

    @NonNull
    public CancellationToken getTemporaryContentUrlsForMedia(@NonNull List<Media> var1, @NonNull CallbackListener<Map<String, String>> var2);

    @NonNull
    public CancellationToken getTemporaryContentUrlsForMediaSids(@NonNull List<String> var1, @NonNull CallbackListener<Map<String, String>> var2);

    @NonNull
    public CancellationToken getTemporaryContentUrlsForAttachedMedia(@NonNull CallbackListener<Map<String, String>> var1);

    public static enum UpdateReason {
        BODY(0),
        ATTRIBUTES(1),
        DELIVERY_RECEIPT(2),
        SUBJECT(3);

        private final int value;

        private UpdateReason(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static UpdateReason fromInt(int value) {
            for (UpdateReason t : UpdateReason.values()) {
                if (t.getValue() != value) continue;
                return t;
            }
            throw new IllegalStateException("Invalid value " + value + " for Message.UpdateReason");
        }
    }
}

