/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated.transitions;

import android.animation.TimeInterpolator;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import androidx.transition.ChangeBounds;
import androidx.transition.ChangeTransform;
import androidx.transition.Fade;
import androidx.transition.Slide;
import androidx.transition.Transition;
import androidx.transition.TransitionPropagation;
import androidx.transition.TransitionSet;
import androidx.transition.Visibility;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.swmansion.reanimated.transitions.SaneSidePropagation;
import com.swmansion.reanimated.transitions.Scale;
import javax.annotation.Nullable;

class TransitionUtils {
    TransitionUtils() {
    }

    @Nullable
    static Transition inflate(ReadableMap config) {
        String type = config.getString("type");
        if ("group".equals(type)) {
            return TransitionUtils.inflateGroup(config);
        }
        if ("in".equals(type)) {
            return TransitionUtils.inflateIn(config);
        }
        if ("out".equals(type)) {
            return TransitionUtils.inflateOut(config);
        }
        if ("change".equals(type)) {
            return TransitionUtils.inflateChange(config);
        }
        throw new JSApplicationIllegalArgumentException("Unrecognized transition type " + type);
    }

    @Nullable
    private static Transition inflateGroup(ReadableMap config) {
        TransitionSet set = new TransitionSet();
        if (config.hasKey("sequence") && config.getBoolean("sequence")) {
            set.setOrdering(1);
        } else {
            set.setOrdering(0);
        }
        ReadableArray transitions = config.getArray("transitions");
        int size = transitions.size();
        for (int i = 0; i < size; ++i) {
            Transition next = TransitionUtils.inflate(transitions.getMap(i));
            if (next == null) continue;
            set.addTransition(next);
        }
        return set;
    }

    static Visibility createVisibilityTransition(String type) {
        if (type == null || "none".equals(type)) {
            return null;
        }
        if ("fade".equals(type)) {
            return new Fade(3);
        }
        if ("scale".equals(type)) {
            return new Scale();
        }
        if ("slide-top".equals(type)) {
            return new Slide(48);
        }
        if ("slide-bottom".equals(type)) {
            return new Slide(80);
        }
        if ("slide-right".equals(type)) {
            return new Slide(5);
        }
        if ("slide-left".equals(type)) {
            return new Slide(3);
        }
        throw new JSApplicationIllegalArgumentException("Invalid transition type " + type);
    }

    private static Transition inflateIn(ReadableMap config) {
        Visibility transition = TransitionUtils.createTransition(config.getString("animation"));
        if (transition == null) {
            return null;
        }
        transition.setMode(1);
        TransitionUtils.configureTransition((Transition)transition, config);
        return transition;
    }

    private static Transition inflateOut(ReadableMap config) {
        Visibility transition = TransitionUtils.createTransition(config.getString("animation"));
        if (transition == null) {
            return null;
        }
        transition.setMode(2);
        TransitionUtils.configureTransition((Transition)transition, config);
        return transition;
    }

    private static Transition inflateChange(ReadableMap config) {
        ChangeBounds changeBounds = new ChangeBounds();
        ChangeTransform changeTransform = new ChangeTransform();
        TransitionUtils.configureTransition((Transition)changeBounds, config);
        TransitionUtils.configureTransition((Transition)changeTransform, config);
        return new TransitionSet().addTransition((Transition)changeBounds).addTransition((Transition)changeTransform);
    }

    private static Visibility createTransition(String type) {
        if (type == null || "none".equals(type)) {
            return null;
        }
        if ("fade".equals(type)) {
            return new Fade(3);
        }
        if ("scale".equals(type)) {
            return new Scale();
        }
        if ("slide-top".equals(type)) {
            return new Slide(48);
        }
        if ("slide-bottom".equals(type)) {
            return new Slide(80);
        }
        if ("slide-right".equals(type)) {
            return new Slide(5);
        }
        if ("slide-left".equals(type)) {
            return new Slide(3);
        }
        throw new JSApplicationIllegalArgumentException("Invalid transition type " + type);
    }

    private static void configureTransition(Transition transition, ReadableMap params) {
        if (params.hasKey("durationMs")) {
            int durationMs = params.getInt("durationMs");
            transition.setDuration((long)durationMs);
        }
        if (params.hasKey("interpolation")) {
            String interpolation = params.getString("interpolation");
            if (interpolation.equals("easeIn")) {
                transition.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            } else if (interpolation.equals("easeOut")) {
                transition.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            } else if (interpolation.equals("easeInOut")) {
                transition.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            } else if (interpolation.equals("linear")) {
                transition.setInterpolator((TimeInterpolator)new LinearInterpolator());
            } else {
                throw new JSApplicationIllegalArgumentException("Invalid interpolation type " + interpolation);
            }
        }
        if (params.hasKey("propagation")) {
            String propagation = params.getString("propagation");
            SaneSidePropagation sidePropagation = new SaneSidePropagation();
            if ("top".equals(propagation)) {
                sidePropagation.setSide(80);
            } else if ("bottom".equals(propagation)) {
                sidePropagation.setSide(48);
            } else if ("left".equals(propagation)) {
                sidePropagation.setSide(5);
            } else if ("right".equals(propagation)) {
                sidePropagation.setSide(3);
            }
            transition.setPropagation((TransitionPropagation)sidePropagation);
        } else {
            transition.setPropagation(null);
        }
        if (params.hasKey("delayMs")) {
            int delayMs = params.getInt("delayMs");
            transition.setStartDelay((long)delayMs);
        }
    }
}

