/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated.nodes;

import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableMap;
import com.swmansion.reanimated.NodesManager;
import com.swmansion.reanimated.Utils;
import com.swmansion.reanimated.nodes.Node;

public class OperatorNode
extends Node {
    private static final Operator ADD = new ReduceOperator(){

        @Override
        public double reduce(Double x, Double y) {
            return x + y;
        }
    };
    private static final Operator SUB = new ReduceOperator(){

        @Override
        public double reduce(Double x, Double y) {
            return x - y;
        }
    };
    private static final Operator MULTIPLY = new ReduceOperator(){

        @Override
        public double reduce(Double x, Double y) {
            return x * y;
        }
    };
    private static final Operator DIVIDE = new ReduceOperator(){

        @Override
        public double reduce(Double x, Double y) {
            return x / y;
        }
    };
    private static final Operator POW = new ReduceOperator(){

        @Override
        public double reduce(Double x, Double y) {
            return Math.pow(x, y);
        }
    };
    private static final Operator MODULO = new ReduceOperator(){

        @Override
        public double reduce(Double x, Double y) {
            return (x % y + y) % y;
        }
    };
    private static final Operator SQRT = new SingleOperator(){

        @Override
        public double eval(Double x) {
            return Math.sqrt(x);
        }
    };
    private static final Operator LOG = new SingleOperator(){

        @Override
        public double eval(Double x) {
            return Math.log(x);
        }
    };
    private static final Operator SIN = new SingleOperator(){

        @Override
        public double eval(Double x) {
            return Math.sin(x);
        }
    };
    private static final Operator COS = new SingleOperator(){

        @Override
        public double eval(Double x) {
            return Math.cos(x);
        }
    };
    private static final Operator TAN = new SingleOperator(){

        @Override
        public double eval(Double x) {
            return Math.tan(x);
        }
    };
    private static final Operator ACOS = new SingleOperator(){

        @Override
        public double eval(Double x) {
            return Math.acos(x);
        }
    };
    private static final Operator ASIN = new SingleOperator(){

        @Override
        public double eval(Double x) {
            return Math.asin(x);
        }
    };
    private static final Operator ATAN = new SingleOperator(){

        @Override
        public double eval(Double x) {
            return Math.atan(x);
        }
    };
    private static final Operator EXP = new SingleOperator(){

        @Override
        public double eval(Double x) {
            return Math.exp(x);
        }
    };
    private static final Operator ROUND = new SingleOperator(){

        @Override
        public double eval(Double x) {
            return Math.round(x);
        }
    };
    private static final Operator AND = new Operator(){

        @Override
        public double evaluate(Node[] input) {
            boolean res = OperatorNode.truthy(input[0].value());
            for (int i = 1; i < input.length && res; ++i) {
                res = res && OperatorNode.truthy(input[i].value());
            }
            return res ? 1.0 : 0.0;
        }
    };
    private static final Operator OR = new Operator(){

        @Override
        public double evaluate(Node[] input) {
            boolean res = OperatorNode.truthy(input[0].value());
            for (int i = 1; i < input.length && !res; ++i) {
                res = res || OperatorNode.truthy(input[i].value());
            }
            return res ? 1.0 : 0.0;
        }
    };
    private static final Operator NOT = new Operator(){

        @Override
        public double evaluate(Node[] input) {
            return OperatorNode.truthy(input[0].value()) ? 0.0 : 1.0;
        }
    };
    private static final Operator DEFINED = new Operator(){

        @Override
        public double evaluate(Node[] input) {
            Object res = input[0].value();
            return res != null && (!(res instanceof Double) || !((Double)res).isNaN()) ? 1.0 : 0.0;
        }
    };
    private static final Operator LESS_THAN = new CompOperator(){

        @Override
        public boolean eval(Double x, Double y) {
            if (x == null || y == null) {
                return false;
            }
            return x < y;
        }
    };
    private static final Operator EQ = new CompOperator(){

        @Override
        public boolean eval(Double x, Double y) {
            if (x == null || y == null) {
                return x == y;
            }
            return x.doubleValue() == y.doubleValue();
        }
    };
    private static final Operator GREATER_THAN = new CompOperator(){

        @Override
        public boolean eval(Double x, Double y) {
            if (x == null || y == null) {
                return false;
            }
            return x > y;
        }
    };
    private static final Operator LESS_OR_EQ = new CompOperator(){

        @Override
        public boolean eval(Double x, Double y) {
            return x <= y;
        }
    };
    private static final Operator GREATER_OR_EQ = new CompOperator(){

        @Override
        public boolean eval(Double x, Double y) {
            return x >= y;
        }
    };
    private static final Operator NEQ = new CompOperator(){

        @Override
        public boolean eval(Double x, Double y) {
            if (x == null || y == null) {
                return x == y;
            }
            return x.doubleValue() != y.doubleValue();
        }
    };
    private final int[] mInputIDs;
    private final Node[] mInputNodes;
    private final Operator mOperator;

    private static boolean truthy(Object value) {
        return value != null && !value.equals(0.0);
    }

    public OperatorNode(int nodeID, ReadableMap config, NodesManager nodesManager) {
        super(nodeID, config, nodesManager);
        this.mInputIDs = Utils.processIntArray(config.getArray("input"));
        this.mInputNodes = new Node[this.mInputIDs.length];
        String op = config.getString("op");
        if ("add".equals(op)) {
            this.mOperator = ADD;
        } else if ("sub".equals(op)) {
            this.mOperator = SUB;
        } else if ("multiply".equals(op)) {
            this.mOperator = MULTIPLY;
        } else if ("divide".equals(op)) {
            this.mOperator = DIVIDE;
        } else if ("pow".equals(op)) {
            this.mOperator = POW;
        } else if ("modulo".equals(op)) {
            this.mOperator = MODULO;
        } else if ("sqrt".equals(op)) {
            this.mOperator = SQRT;
        } else if ("log".equals(op)) {
            this.mOperator = LOG;
        } else if ("sin".equals(op)) {
            this.mOperator = SIN;
        } else if ("cos".equals(op)) {
            this.mOperator = COS;
        } else if ("tan".equals(op)) {
            this.mOperator = TAN;
        } else if ("acos".equals(op)) {
            this.mOperator = ACOS;
        } else if ("asin".equals(op)) {
            this.mOperator = ASIN;
        } else if ("atan".equals(op)) {
            this.mOperator = ATAN;
        } else if ("exp".equals(op)) {
            this.mOperator = EXP;
        } else if ("round".equals(op)) {
            this.mOperator = ROUND;
        } else if ("and".equals(op)) {
            this.mOperator = AND;
        } else if ("or".equals(op)) {
            this.mOperator = OR;
        } else if ("not".equals(op)) {
            this.mOperator = NOT;
        } else if ("defined".equals(op)) {
            this.mOperator = DEFINED;
        } else if ("lessThan".equals(op)) {
            this.mOperator = LESS_THAN;
        } else if ("eq".equals(op)) {
            this.mOperator = EQ;
        } else if ("greaterThan".equals(op)) {
            this.mOperator = GREATER_THAN;
        } else if ("lessOrEq".equals(op)) {
            this.mOperator = LESS_OR_EQ;
        } else if ("greaterOrEq".equals(op)) {
            this.mOperator = GREATER_OR_EQ;
        } else if ("neq".equals(op)) {
            this.mOperator = NEQ;
        } else {
            throw new JSApplicationIllegalArgumentException("Unrecognized operator " + op);
        }
    }

    @Override
    protected Object evaluate() {
        for (int i = 0; i < this.mInputIDs.length; ++i) {
            this.mInputNodes[i] = this.mNodesManager.findNodeById(this.mInputIDs[i], Node.class);
        }
        return this.mOperator.evaluate(this.mInputNodes);
    }

    private static abstract class CompOperator
    implements Operator {
        private CompOperator() {
        }

        @Override
        public double evaluate(Node[] input) {
            return this.eval((Double)input[0].value(), (Double)input[1].value()) ? 1.0 : 0.0;
        }

        public abstract boolean eval(Double var1, Double var2);
    }

    private static abstract class SingleOperator
    implements Operator {
        private SingleOperator() {
        }

        @Override
        public double evaluate(Node[] input) {
            return this.eval((Double)input[0].value());
        }

        public abstract double eval(Double var1);
    }

    private static abstract class ReduceOperator
    implements Operator {
        private ReduceOperator() {
        }

        @Override
        public double evaluate(Node[] input) {
            double acc = input[0].doubleValue();
            for (int i = 1; i < input.length; ++i) {
                acc = this.reduce(acc, input[i].doubleValue());
            }
            return acc;
        }

        public abstract double reduce(Double var1, Double var2);
    }

    private static interface Operator {
        public double evaluate(Node[] var1);
    }
}

