/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated.nodes;

import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UiThreadUtil;
import com.swmansion.reanimated.NodesManager;
import com.swmansion.reanimated.UpdateContext;
import com.swmansion.reanimated.nodes.FinalNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;

public abstract class Node {
    public static final Double ZERO = 0.0;
    public static final Double ONE = 1.0;
    protected final int mNodeID;
    protected final NodesManager mNodesManager;
    protected final UpdateContext mUpdateContext;
    private final Map<String, Long> mLastLoopID = new HashMap<String, Long>();
    private final Map<String, Object> mMemoizedValue = new HashMap<String, Object>();
    @Nullable
    private List<Node> mChildren;

    public Node(int nodeID, @Nullable ReadableMap config, NodesManager nodesManager) {
        this.mLastLoopID.put("", -1L);
        this.mNodeID = nodeID;
        this.mNodesManager = nodesManager;
        this.mUpdateContext = nodesManager.updateContext;
    }

    @Nullable
    protected abstract Object evaluate();

    @Nullable
    public final Object value() {
        if (!this.mLastLoopID.containsKey(this.mUpdateContext.callID) || this.mLastLoopID.get(this.mUpdateContext.callID) < this.mUpdateContext.updateLoopID) {
            this.mLastLoopID.put(this.mUpdateContext.callID, this.mUpdateContext.updateLoopID);
            Object result = this.evaluate();
            this.mMemoizedValue.put(this.mUpdateContext.callID, result);
            return result;
        }
        return this.mMemoizedValue.get(this.mUpdateContext.callID);
    }

    public final Double doubleValue() {
        Object value = this.value();
        if (value == null) {
            return ZERO;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? ONE : ZERO;
        }
        throw new IllegalStateException("Value of node " + this + " cannot be cast to a number");
    }

    public void addChild(Node child) {
        if (this.mChildren == null) {
            this.mChildren = new ArrayList<Node>();
        }
        this.mChildren.add(child);
        child.dangerouslyRescheduleEvaluate();
    }

    public void removeChild(Node child) {
        if (this.mChildren != null) {
            this.mChildren.remove(child);
        }
    }

    protected void markUpdated() {
        UiThreadUtil.assertOnUiThread();
        this.mUpdateContext.updatedNodes.add(this);
        this.mNodesManager.postRunUpdatesAfterAnimation();
    }

    protected final void dangerouslyRescheduleEvaluate() {
        this.mLastLoopID.put(this.mUpdateContext.callID, -1L);
        this.markUpdated();
    }

    protected final void forceUpdateMemoizedValue(Object value) {
        this.mMemoizedValue.put(this.mUpdateContext.callID, value);
        this.markUpdated();
    }

    private static void findAndUpdateNodes(Node node, Set<Node> visitedNodes, Stack<FinalNode> finalNodes) {
        if (visitedNodes.contains(node)) {
            return;
        }
        visitedNodes.add(node);
        List<Node> children = node.mChildren;
        if (children != null) {
            for (Node child : children) {
                Node.findAndUpdateNodes(child, visitedNodes, finalNodes);
            }
        }
        if (node instanceof FinalNode) {
            finalNodes.push((FinalNode)((Object)node));
        }
    }

    public static void runUpdates(UpdateContext updateContext) {
        UiThreadUtil.assertOnUiThread();
        ArrayList<Node> updatedNodes = updateContext.updatedNodes;
        HashSet<Node> visitedNodes = new HashSet<Node>();
        Stack<FinalNode> finalNodes = new Stack<FinalNode>();
        for (int i = 0; i < updatedNodes.size(); ++i) {
            Node.findAndUpdateNodes(updatedNodes.get(i), visitedNodes, finalNodes);
            if (i != updatedNodes.size() - 1) continue;
            while (!finalNodes.isEmpty()) {
                finalNodes.pop().update();
            }
        }
        updatedNodes.clear();
        ++updateContext.updateLoopID;
    }
}

