/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated.nodes;

import com.facebook.react.bridge.ReadableMap;
import com.swmansion.reanimated.MapUtils;
import com.swmansion.reanimated.NodesManager;
import com.swmansion.reanimated.nodes.Node;

public class CondNode
extends Node {
    private final int mCondID;
    private final int mIfBlockID;
    private final int mElseBlockID;

    public CondNode(int nodeID, ReadableMap config, NodesManager nodesManager) {
        super(nodeID, config, nodesManager);
        this.mCondID = MapUtils.getInt(config, "cond", "Reanimated: First argument passed to cond node is either of wrong type or is missing.");
        this.mIfBlockID = MapUtils.getInt(config, "ifBlock", "Reanimated: Second argument passed to cond node is either of wrong type or is missing.");
        this.mElseBlockID = config.hasKey("elseBlock") ? MapUtils.getInt(config, "elseBlock", "Reanimated: Second argument passed to cond node is either of wrong type or is missing.") : -1;
    }

    @Override
    protected Object evaluate() {
        Object cond = this.mNodesManager.getNodeValue(this.mCondID);
        if (cond instanceof Number && ((Number)cond).doubleValue() != 0.0) {
            return this.mIfBlockID != -1 ? this.mNodesManager.getNodeValue(this.mIfBlockID) : ZERO;
        }
        return this.mElseBlockID != -1 ? this.mNodesManager.getNodeValue(this.mElseBlockID) : ZERO;
    }
}

