/*
 * Decompiled with CFR 0.152.
 */
package com.swmansion.reanimated.nodes;

import android.graphics.PointF;
import com.facebook.react.bridge.ReadableMap;
import com.swmansion.reanimated.MapUtils;
import com.swmansion.reanimated.NodesManager;
import com.swmansion.reanimated.nodes.Node;

public class BezierNode
extends Node {
    private final int mInputID;
    private final CubicBezierInterpolator mInterpolator;

    public BezierNode(int nodeID, ReadableMap config, NodesManager nodesManager) {
        super(nodeID, config, nodesManager);
        this.mInputID = MapUtils.getInt(config, "input", "Reanimated: Argument passed to bezier node is either of wrong type or is missing.");
        float startX = (float)config.getDouble("mX1");
        float startY = (float)config.getDouble("mY1");
        float endX = (float)config.getDouble("mX2");
        float endY = (float)config.getDouble("mY2");
        this.mInterpolator = new CubicBezierInterpolator(startX, startY, endX, endY);
    }

    @Override
    protected Double evaluate() {
        Double in = (Double)this.mNodesManager.getNodeValue(this.mInputID);
        return this.mInterpolator.getInterpolation(in.floatValue());
    }

    private static class CubicBezierInterpolator {
        protected PointF start;
        protected PointF end;
        protected PointF a = new PointF();
        protected PointF b = new PointF();
        protected PointF c = new PointF();

        public CubicBezierInterpolator(PointF start, PointF end) {
            this.start = start;
            this.end = end;
        }

        public CubicBezierInterpolator(float startX, float startY, float endX, float endY) {
            this(new PointF(startX, startY), new PointF(endX, endY));
        }

        public float getInterpolation(float time) {
            return this.getBezierCoordinateY(this.getXForTime(time));
        }

        protected float getBezierCoordinateY(float time) {
            this.c.y = 3.0f * this.start.y;
            this.b.y = 3.0f * (this.end.y - this.start.y) - this.c.y;
            this.a.y = 1.0f - this.c.y - this.b.y;
            return time * (this.c.y + time * (this.b.y + time * this.a.y));
        }

        protected float getXForTime(float time) {
            float z;
            float x = time;
            for (int i = 1; i < 14 && !((double)Math.abs(z = this.getBezierCoordinateX(x) - time) < 0.001); ++i) {
                x -= z / this.getXDerivate(x);
            }
            return x;
        }

        private float getXDerivate(float t) {
            return this.c.x + t * (2.0f * this.b.x + 3.0f * this.a.x * t);
        }

        private float getBezierCoordinateX(float time) {
            this.c.x = 3.0f * this.start.x;
            this.b.x = 3.0f * (this.end.x - this.start.x) - this.c.x;
            this.a.x = 1.0f - this.c.x - this.b.x;
            return time * (this.c.x + time * (this.b.x + time * this.a.x));
        }
    }
}

