/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor.aspect;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.tts.android.aopmonitor.AOPMonitor;
import com.tts.android.aopmonitor.bean.ViewClickAction;
import com.tts.android.aopmonitor.tools.LogUtils;
import java.io.Serializable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class WebRecordAspect {
    @Pointcut(value="execution(@com.tts.android.aopmonitor.annotation.WebRecord * *(..))")
    public void webRecord() {
    }

    @After(value="webRecord()")
    public void doWebRecord(JoinPoint point) {
        Object[] args = point.getArgs();
        String actionJson = "";
        Context context = null;
        if (args.length == 1 && args[0] instanceof String) {
            actionJson = String.valueOf(args[0]);
        }
        if (AOPMonitor.mContext == null) {
            LogUtils.loge("AOPMonitor is not inited");
            return;
        }
        context = AOPMonitor.mContext;
        if (!TextUtils.isEmpty((CharSequence)actionJson)) {
            try {
                ViewClickAction action = (ViewClickAction)new Gson().fromJson(actionJson, ViewClickAction.class);
                this.sendAction(context, action);
            }
            catch (Exception e) {
                LogUtils.loge("the webview actionjson has not a correct format");
            }
        } else {
            LogUtils.loge("the method has no String argument");
        }
    }

    public void sendAction(Context context, ViewClickAction action) {
        Intent intent = new Intent();
        intent.setAction("com.record");
        intent.putExtra("type", 1001);
        intent.putExtra("data", (Serializable)action);
        context.sendBroadcast(intent);
    }
}

