package com.tts.android.aopmonitor.tools;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.Log;

import static android.content.ContentValues.TAG;

/**
 * meta-data读取工具
 * @author shijianting
 * 2018/11/20 3:19 PM
 */
public class MetaDataUtil {

    public static String getMetaDataFromApp(String key) {

        Context context;

        if (Constants.appContext == null) {
            return null;
        }

        context = Constants.appContext;

        ApplicationInfo info = null;

        try {
            info = context.getPackageManager()
                    .getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            return (String) info.metaData.get(key);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}
