package com.tts.android.aopmonitor.actmanager;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;

/**
 * 管理activity跳转回传数据
 * @author shijianting
 * 2018/9/13 上午10:12
 */
public class ActivityStartResultManager {

    private static final String TAG = ActivityStartResultManager.class.getSimpleName();
    private StartCallbackFragment mStartCallbackFragment;

    /**
     * 跳转 Activity 的 Class 对象
     */
    private Class<?> mTargetClass;

    /**
     * 从开始 Activity 传给数据源目标 Activity的数据
     */
    private Bundle mDataBundle;

    /**
     * uri跳转使用的action
     */
    private String mAction;

    /**
     * uri跳转
     */
    private Uri mUri;

    public static ActivityStartResultManager get() {
        return new ActivityStartResultManager();
    }

    private ActivityStartResultManager() {
    }

    public ActivityStartResultManager from(Activity activity) {
        mStartCallbackFragment = createStartCallbackFragment(activity);
        return this;
    }

    public ActivityStartResultManager from(Fragment fragment) {
        this.from(fragment.getActivity());
        return this;
    }

    public ActivityStartResultManager to(Class<?> clazz) {
        this.mTargetClass = clazz;
        return this;
    }


    public ActivityStartResultManager bundle(Bundle bundle) {
        mDataBundle = new Bundle(bundle);
        return this;
    }

    public ActivityStartResultManager action(String action) {
        mAction = action;
        return this;
    }

    public ActivityStartResultManager uri(Uri uri) {
        mUri = uri;
        return this;
    }

    /**
     * 开启目标 Activity
     *
     * @param callback 结果回调
     */
    public void startForResult(@NonNull ActivityResultCallBack callback) {
        if (mStartCallbackFragment == null) {
            throw new NullPointerException("From activity is null , forget from() ?");
        }
        Activity activity = mStartCallbackFragment.getActivity();
        if (activity == null) {
            // 若为 Activity 为 Null，说明场景不再适合使用 StartForResultManager
            throw new NullPointerException("Surprise , something is error , perhaps this is love");
        }
        Intent intent = null;
        if (null != mTargetClass) {
            intent = new Intent(activity, mTargetClass);
            if (mDataBundle != null) {
                intent.putExtras(mDataBundle);
            }
        }
        else if (mAction != null && mUri != null) {
            intent = new Intent(mAction, mUri);
            if (mDataBundle != null) {
                intent.putExtras(mDataBundle);
            }
        }
        else {
            throw new NullPointerException("target is null , forget to() or action()&uri() ?");
        }
        fragmentStartForResult(intent, callback.hashCode(), callback);
    }

    /**
     * 创建中间桥梁 Fragment
     *
     * @param activity 启动 Activity ：桥梁 Fragment 所依赖的 Activity
     * @return Fragment
     */
    private StartCallbackFragment createStartCallbackFragment(Activity activity) {
        StartCallbackFragment resultFragment = findStartCallbackFragment(activity);
        if (resultFragment == null) {
            resultFragment = new StartCallbackFragment();
            FragmentManager fragmentManager = activity.getFragmentManager();
            fragmentManager
                    .beginTransaction()
                    .add(resultFragment, TAG)
                    .commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return resultFragment;
    }

    /**
     * 查找中间桥梁 Fragment
     *
     * @param activity 启动 Activity
     * @return Fragment
     */
    private StartCallbackFragment findStartCallbackFragment(Activity activity) {
        return (StartCallbackFragment) activity.getFragmentManager().findFragmentByTag(TAG);
    }

    /**
     * 通过桥梁 Fragment 启动数据源目标 Activity
     *
     * @param intent      Intent
     * @param requestCode 请求码
     * @param callback    结果回调
     */
    private void fragmentStartForResult(Intent intent, int requestCode, ActivityResultCallBack callback) {
        mStartCallbackFragment.startForResult(intent, requestCode, callback);
    }


}
