package com.tts.android.aopmonitor;

public class AOPOptions {

    private boolean debug = false;

    private int multiClickDuring = 500;

    public static class Builder{

        AOPOptions target;

        public Builder() {
            target = new AOPOptions();
        }

        public Builder debug(boolean debug) {
            target.debug = debug;
            return this;
        }

        public Builder multiClickDuring(int during) {
            target.multiClickDuring = during;
            return this;
        }

        public AOPOptions build() {
            return target;
        }
    }

    public boolean isDebug() {
        return debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getMultiClickDuring() {
        return multiClickDuring;
    }

    public void setMultiClickDuring(int multiClickDuring) {
        this.multiClickDuring = multiClickDuring;
    }

}
