package com.tts.android.aopmonitor;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;

import com.google.gson.Gson;
import com.tts.android.aopmonitor.aspect.ClickRecordAspect;
import com.tts.android.aopmonitor.bean.ViewClickAction;
import com.tts.android.aopmonitor.net.NetManager;
import com.tts.android.aopmonitor.net.bean.RecordRequestBean;
import com.tts.android.aopmonitor.tools.Constants;
import com.tts.android.aopmonitor.tools.CtwUtils;
import com.tts.android.aopmonitor.tools.LogUtils;
import com.tts.android.aopmonitor.tools.TimeUtils;

import java.lang.ref.SoftReference;

import static com.tts.android.aopmonitor.RecordService.initBaseRecordBean;

/**
 * a few usual methods of the framework
 * @author shijianting
 * 2018/10/26 8:27 AM
 */
public class AOPMonitorUtil {

    /**
     * set the extend data on the view
     * @param view
     * @param extend
     */
    public static void setExtendData(View view, String extend) {
        view.setTag(R.id.aopmonitor_extend, extend);
    }

    /**
     * set the contentDescription on the view
     * @param view
     * @param des
     */
    public static void setDescription(View view, String des) {
        view.setContentDescription(des);
    }

    /**
     * set user id and bind xg user {@link Constants}
     * the id may not be setted at the time that the app is initing.
     * so creating a method for setting it.
     * by sjt
     * @param userId
     */
    public static void setUserId(String userId) {
        if (!TextUtils.isEmpty(userId)) {
            Constants.userId = userId;
            //信鸽绑定账号
            if (null != Constants.appContext) {

            }
        }
    }

    /**
     * set location latitude
     * @param latitude jd
     */
    public static void setLatitude(String latitude) {
        Constants.latitude = latitude;
    }

    /**
     * set location altitude
     * @param altitude wd
     */
    public static void setAltitude(String altitude) {
        Constants.altitude = altitude;
    }

    /**
     * add onclicklistener to the view,let the view has record function.
     * @param v
     */
    public static void addRecordToView(View v) {

        v.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

            }
        });
    }

    /**
     * add onclicklistener to the edittext,let the view has record function.
     * class-EditText:record with the content of edittext
     * @param v 控件
     * @param cls 控件类型
     */
    public static void addRecordToView(View v, Class cls) {
        if (cls == EditText.class) {
            AOPMonitorUtil.setExtendData(v, ((EditText) v).getText().toString());
        }

        addRecordToView(v);
    }

    /**
     * send a record by method
     * use for the method without view param
     * @param pageId
     * @param widgetId
     * @param extend
     */
    public static void sendOneRecord(String pageId, String widgetId, String extend) {
        if (null == Constants.appContext) {
            LogUtils.loge("cannot send a record, AOPMonitor is not inited");
            return;
        }
        ViewClickAction action = new ViewClickAction();
        action.setWidgetId(TextUtils.isEmpty(widgetId) ? "" : widgetId);
        action.setPageId(TextUtils.isEmpty(pageId) ? "" : pageId);
        action.setExtend(TextUtils.isEmpty(extend) ? "" : extend);
        action.setTimeStamp(TimeUtils.getTimeStamp());
        Intent intent = new Intent();
        intent.setAction(RecordService.RECORD_TAG);
        intent.putExtra(RecordService.ACTION_TYPE, RecordService.ACTION_RECORD);
        intent.putExtra(RecordService.DATA, action);
        Constants.appContext.sendBroadcast(intent);
    }

    /**
     * 同步在基类Activity的onResume中执行
     * 功能1：记录页面跳转
     * @param context
     */
    public static void onResume(SoftReference<Context> context) {
        String name = ClickRecordAspect.getPageName(context.get());
        RecordRequestBean bean = new RecordRequestBean();
        bean = initBaseRecordBean(bean);
        bean.setPageId(name);
        bean.setReferer(getLastPageName(context.get()));
        //对象转String，加入基础数据
        String actionStr = new Gson().toJson(CtwUtils.initCtwRecordBean(bean));
        NetManager.getInstance(context.get()).doRecord(actionStr);
    }

    public static final String AOP_LAST_PAGE_ID = "AOP_LAST_PAGE_ID";

    private static String getLastPageName(Context context){
        if(context!=null && context instanceof  Activity){
           Intent intent = ((Activity) context).getIntent();
           if(intent!=null){
               String pageID =intent.getStringExtra(AOP_LAST_PAGE_ID);
               if(!TextUtils.isEmpty(pageID)){
                   return pageID;
               }
           }
        }
        return null;
    }




    /**
     * 判断用户行为记录服务是否还在运行
     * @return
     */
    public static boolean isRecordServiceAlive() {
        return RecordService.isServiceRunning();
    }
}
