/*
 * Decompiled with CFR 0.152.
 */
package com.tts.android.aopmonitor.tools.crash;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.os.Process;
import android.widget.Toast;
import com.blankj.utilcode.util.CacheDiskUtils;
import com.google.gson.Gson;
import com.tts.android.aopmonitor.RecordService;
import com.tts.android.aopmonitor.bean.ViewClickAction;
import com.tts.android.aopmonitor.net.bean.RecordRequestBean;
import com.tts.android.aopmonitor.tools.CtwUtils;
import com.tts.android.aopmonitor.tools.LogUtils;
import com.tts.android.aopmonitor.tools.TimeUtils;
import com.tts.android.aopmonitor.tools.crash.MyActivityLifecycleCallbacks;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = "CrashHandler";
    private static Toast mCustomToast;
    private static String mCrashTip;
    private static String mCrashTip2;
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private static CrashHandler mCrashHandler;
    public Application mApplication;
    MyActivityLifecycleCallbacks mMyActivityLifecycleCallbacks = new MyActivityLifecycleCallbacks();
    private Map<String, String> infos = new HashMap<String, String>();
    private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private boolean mIsDebug;
    private boolean mIsShowToast;
    private boolean mIsRestartApp;
    private long mRestartTime;
    private Class mClassOfFirstActivity;
    private boolean hasToast;

    public static CrashHandler getInstance() {
        if (mCrashHandler == null) {
            mCrashHandler = new CrashHandler();
        }
        return mCrashHandler;
    }

    public void init(Application application, boolean isDebug, boolean isShowToast, boolean isRestartApp, long restartTime, Class classOfFirstActivity) {
        this.mIsShowToast = isShowToast;
        this.mIsRestartApp = isRestartApp;
        this.mRestartTime = restartTime;
        this.mClassOfFirstActivity = classOfFirstActivity;
        this.initCrashHandler(application, isDebug);
    }

    public void init(Application application, boolean isDebug) {
        this.initCrashHandler(application, isDebug);
    }

    @TargetApi(value=14)
    private void initCrashHandler(Application application, boolean isDebug) {
        this.mIsDebug = isDebug;
        this.mApplication = application;
        this.mApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mMyActivityLifecycleCallbacks);
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        boolean isHandle = this.handleException(ex);
        if (!isHandle && this.mDefaultHandler != null) {
            this.mDefaultHandler.uncaughtException(thread, ex);
        } else {
            try {
                Thread.sleep(2800L);
            }
            catch (InterruptedException e) {
                LogUtils.loge("uncaughtException() InterruptedException:" + e);
            }
            if (this.mIsRestartApp) {
                AlarmManager mgr = (AlarmManager)this.mApplication.getSystemService("alarm");
                try {
                    Intent intent = new Intent((Context)this.mApplication, this.mClassOfFirstActivity);
                    intent.setFlags(0x10000000);
                    PendingIntent restartIntent = PendingIntent.getActivity((Context)this.mApplication, (int)0, (Intent)intent, (int)0x40000000);
                    mgr.set(1, System.currentTimeMillis() + this.mRestartTime, restartIntent);
                }
                catch (Exception e) {
                    LogUtils.loge("first class error:" + e);
                }
            }
            this.mMyActivityLifecycleCallbacks.removeAllActivities();
            Process.killProcess((int)Process.myPid());
            System.exit(1);
            System.gc();
        }
    }

    private boolean handleException(Throwable ex) {
        if (this.mIsShowToast && !this.hasToast) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Toast toast;
                        Looper.prepare();
                        if (mCustomToast == null) {
                            toast = CrashHandler.this.mIsRestartApp ? Toast.makeText((Context)CrashHandler.this.mApplication, (CharSequence)mCrashTip2, (int)1) : Toast.makeText((Context)CrashHandler.this.mApplication, (CharSequence)mCrashTip, (int)1);
                            toast.setGravity(17, 0, 0);
                        } else {
                            toast = mCustomToast;
                        }
                        toast.show();
                        Looper.loop();
                        CrashHandler.this.hasToast = true;
                    }
                    catch (Exception e) {
                        LogUtils.loge("handleException Toast error" + e);
                    }
                }
            }).start();
        }
        if (ex == null) {
            return false;
        }
        if (this.mIsDebug) {
            LogUtils.logd("save crash info in disk, after restart app,resend");
            ViewClickAction action = new ViewClickAction();
            action.setWidgetId(ex.toString());
            action.setPageId("crash");
            action.setExtend(this.getCrashInfo(ex));
            action.setTimeStamp(TimeUtils.getTimeStamp());
            ArrayList<ViewClickAction> actions = new ArrayList<ViewClickAction>();
            actions.add(action);
            RecordRequestBean recordRequestBean = new RecordRequestBean();
            recordRequestBean = RecordService.initBaseRecordBean(recordRequestBean);
            recordRequestBean.setActions(actions);
            String actionStr = new Gson().toJson((Object)CtwUtils.initCtwRecordBean(recordRequestBean));
            CacheDiskUtils.getInstance().put("crash", actionStr);
        }
        return true;
    }

    public String getCrashInfo(Throwable ex) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        ex.setStackTrace(ex.getStackTrace());
        ex.printStackTrace(printWriter);
        printWriter.close();
        return ((Object)result).toString();
    }

    static {
        mCrashTip = "\u5f88\u62b1\u6b49,\u7a0b\u5e8f\u51fa\u73b0\u5f02\u5e38,\u5373\u5c06\u9000\u51fa.";
        mCrashTip2 = "\u5f88\u62b1\u6b49,\u7a0b\u5e8f\u51fa\u73b0\u5f02\u5e38,\u5373\u5c06\u91cd\u542f.";
    }
}

