package com.tts.android.aopmonitor.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 页面名称注解
 * 保留原统计方式的注解名称，方便修改
 * @author shijianting
 * 2018/10/29 2:03 PM
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface PageStatistics {

    /**
     * Find by resource id
     * @return
     */
    int name() default -1;

    /**
     * direct name
     * @return
     */
    String value() default "";
}