/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonEnvironment.model;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import com.trx.neon.api.neonEnvironment.model.LatLong;
import com.trx.neon.api.neonEnvironment.model.LatLongOutline;
import com.trx.neon.api.neonEnvironment.model.NeonBuildingFloor;
import com.trx.neon.api.neonEnvironment.model.NeonFloorOutline;
import java.util.ArrayList;

public class NeonFloorPlan {
    private final String ID;
    private final Bitmap Image;
    private final NeonBuildingFloor Floor;
    private final LatLong TopLeft;
    private final LatLong TopRight;
    private final LatLong BottomRight;
    private final LatLong BottomLeft;

    public NeonFloorPlan(Bitmap bitmap, NeonBuildingFloor floor) {
        if (floor.getFloorPlanCorners() == null || floor.getFloorPlanCorners().size() != 4) {
            throw new IllegalArgumentException("Must have four valid corners for a floor plan");
        }
        this.ID = floor.getFloorPlanImageID();
        this.Image = bitmap;
        this.Floor = floor;
        this.TopLeft = floor.getFloorPlanCorners().get(3);
        this.TopRight = floor.getFloorPlanCorners().get(2);
        this.BottomRight = floor.getFloorPlanCorners().get(1);
        this.BottomLeft = floor.getFloorPlanCorners().get(0);
    }

    public String getID() {
        return this.ID;
    }

    public Bitmap getBitmap() {
        return this.Image;
    }

    public Bitmap getBitmapClippedToFloor() {
        if (this.Image == null) {
            return null;
        }
        Bitmap mask = Bitmap.createBitmap((int)this.Image.getWidth(), (int)this.Image.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        mask.eraseColor(0);
        Bitmap result = Bitmap.createBitmap((int)this.Image.getWidth(), (int)this.Image.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        result.eraseColor(0);
        LatLong origin = this.getTopLeft();
        double[] X = new double[]{this.getTopRight().Longitude - origin.Longitude, this.getTopRight().Latitude - origin.Latitude};
        double[] Y = new double[]{this.getBottomLeft().Longitude - origin.Longitude, this.getBottomLeft().Latitude - origin.Latitude};
        double determinant = 1.0 / (X[0] * Y[1] - Y[0] * X[1]);
        double a = Y[1] * determinant;
        double b = -Y[0] * determinant;
        double c = -X[1] * determinant;
        double d = X[0] * determinant;
        Canvas canvas = new Canvas(mask);
        Paint fill = new Paint(1);
        fill.setAntiAlias(true);
        fill.setStyle(Paint.Style.FILL);
        fill.setColor(-65536);
        Paint unfill = new Paint(1);
        unfill.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        unfill.setAntiAlias(true);
        unfill.setStyle(Paint.Style.FILL);
        unfill.setColor(0);
        NeonFloorOutline outline = this.Floor.getOutline();
        for (LatLongOutline polygonWithHoles : outline.Outlines) {
            ArrayList<LatLong> hull = polygonWithHoles.Hull;
            ArrayList<ArrayList<LatLong>> holes = polygonWithHoles.Holes;
            Path hullPath = new Path();
            for (int i = 0; i < hull.size(); ++i) {
                LatLong hullPt = hull.get(i);
                double ptX = hullPt.Longitude - origin.Longitude;
                double ptY = hullPt.Latitude - origin.Latitude;
                double u = ptX * a + ptY * b;
                double v = ptX * c + ptY * d;
                u *= (double)mask.getWidth();
                v *= (double)mask.getHeight();
                if (i == 0) {
                    hullPath.moveTo((float)u, (float)v);
                } else {
                    hullPath.lineTo((float)u, (float)v);
                }
                if (i != hull.size() - 1) continue;
                hullPath.close();
            }
            canvas.drawPath(hullPath, fill);
            for (ArrayList<LatLong> hole : holes) {
                Path holePath = new Path();
                for (int i = 0; i < hole.size(); ++i) {
                    LatLong holePt = hole.get(i);
                    double ptX = holePt.Longitude - origin.Longitude;
                    double ptY = holePt.Latitude - origin.Latitude;
                    double u = ptX * a + ptY * b;
                    double v = ptX * c + ptY * d;
                    u *= (double)mask.getWidth();
                    v *= (double)mask.getHeight();
                    if (i == 0) {
                        holePath.moveTo((float)u, (float)v);
                    } else {
                        holePath.lineTo((float)u, (float)v);
                    }
                    if (i != hole.size() - 1) continue;
                    holePath.close();
                }
                canvas.drawPath(holePath, unfill);
            }
        }
        Paint clip = new Paint(1);
        clip.setAntiAlias(true);
        clip.setStyle(Paint.Style.FILL);
        clip.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        Canvas resultCanvas = new Canvas(result);
        resultCanvas.drawBitmap(this.getBitmap(), 0.0f, 0.0f, null);
        resultCanvas.drawBitmap(mask, 0.0f, 0.0f, clip);
        mask.recycle();
        return result;
    }

    public LatLong getTopLeft() {
        return this.TopLeft;
    }

    public LatLong getTopRight() {
        return this.TopRight;
    }

    public LatLong getBottomRight() {
        return this.BottomRight;
    }

    public LatLong getBottomLeft() {
        return this.BottomLeft;
    }
}

