/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonBeta.model.events;

import android.os.Parcel;
import android.os.Parcelable;
import com.trx.neon.api.neon.model.types.NeonEventConstants;
import com.trx.neon.api.neonBeta.model.interfaces.INeonEventBeta;
import java.util.Date;

public final class VehicleStateEvent
implements Parcelable,
INeonEventBeta {
    private final long unixTimeMs;
    private final String type;
    public static final Parcelable.Creator<VehicleStateEvent> CREATOR = new Parcelable.Creator<VehicleStateEvent>(){

        public VehicleStateEvent createFromParcel(Parcel in) {
            return new VehicleStateEvent(in);
        }

        public VehicleStateEvent[] newArray(int size) {
            return new VehicleStateEvent[size];
        }
    };

    public VehicleStateEventType getType() {
        try {
            return Enum.valueOf(VehicleStateEventType.class, this.type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public VehicleStateEvent(long unixTimeMs, VehicleStateEventType type) {
        this.unixTimeMs = unixTimeMs;
        this.type = type.name();
    }

    private VehicleStateEvent(Parcel in) {
        this.unixTimeMs = in.readLong();
        this.type = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.unixTimeMs);
        dest.writeString(this.type);
    }

    public String toString() {
        return "Time: " + NeonEventConstants.DEFAULT_DATE_FORMAT.format(new Date(this.unixTimeMs)) + ", " + "Type: " + this.type;
    }

    public static enum VehicleStateEventType {
        UNKNOWN,
        START,
        END;

    }
}

