/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonBeta.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class NeonInertialDelta
implements Parcelable {
    public final long time;
    public final float deltaHeading;
    public final float deltaX;
    public final float deltaY;
    public final float deltaZ;
    public final float errorRadius;
    public static final Parcelable.Creator<NeonInertialDelta> CREATOR = new Parcelable.Creator<NeonInertialDelta>(){

        public NeonInertialDelta createFromParcel(Parcel in) {
            return new NeonInertialDelta(in);
        }

        public NeonInertialDelta[] newArray(int size) {
            return new NeonInertialDelta[size];
        }
    };
    private static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());

    public NeonInertialDelta(long unixTimeMs, float deltaHeading, float deltaX, float deltaY, float deltaZ, float errorRadius) {
        this.time = SystemClock.elapsedRealtime() - System.currentTimeMillis() + unixTimeMs;
        this.deltaHeading = deltaHeading;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.deltaZ = deltaZ;
        this.errorRadius = errorRadius;
    }

    public NeonInertialDelta(NeonInertialDelta loc) {
        this(loc.time, loc.deltaHeading, loc.deltaX, loc.deltaY, loc.deltaZ, loc.errorRadius);
    }

    private NeonInertialDelta(Parcel in) {
        this.time = in.readLong();
        this.deltaHeading = in.readFloat();
        this.deltaX = in.readFloat();
        this.deltaY = in.readFloat();
        this.deltaZ = in.readFloat();
        this.errorRadius = in.readFloat();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.time);
        dest.writeFloat(this.deltaHeading);
        dest.writeFloat(this.deltaX);
        dest.writeFloat(this.deltaY);
        dest.writeFloat(this.deltaZ);
        dest.writeFloat(this.errorRadius);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        long unixTimeMs = System.currentTimeMillis() - SystemClock.elapsedRealtime() + this.time;
        sb.append("Time: " + DEFAULT_DATE_FORMAT.format(new Date(unixTimeMs)) + ", ");
        sb.append("DeltaHeading: " + this.deltaHeading + ", ");
        sb.append("DeltaX: " + this.deltaX + ", ");
        sb.append("DeltaY: " + this.deltaY + ", ");
        sb.append("DeltaZ: " + this.deltaZ + ", ");
        sb.append("Error Radius: " + this.errorRadius);
        return sb.toString();
    }
}

