/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonBeta.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.trx.neon.api.neonBeta.model.ElevationInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class LineSegmentConstraint
implements Parcelable {
    private final long timestamp;
    public final double StartLatitude;
    public final double StartLongitude;
    public final double EndLatitude;
    public final double EndLongitude;
    public final float LocationError;
    public final ElevationInfo Elevation;
    public final SegmentStatus Status;
    public static final Parcelable.Creator<LineSegmentConstraint> CREATOR = new Parcelable.Creator<LineSegmentConstraint>(){

        public LineSegmentConstraint createFromParcel(Parcel in) {
            return new LineSegmentConstraint(in);
        }

        public LineSegmentConstraint[] newArray(int size) {
            return new LineSegmentConstraint[size];
        }
    };

    public LineSegmentConstraint(long unixTimeMs, double startLatitude, double startLongitude, double endLatitude, double endLongitude, float locationError, ElevationInfo elevation, SegmentStatus status) {
        this.timestamp = SystemClock.elapsedRealtime() - System.currentTimeMillis() + unixTimeMs;
        this.StartLatitude = startLatitude;
        this.StartLongitude = startLongitude;
        this.EndLatitude = endLatitude;
        this.EndLongitude = endLongitude;
        this.LocationError = locationError;
        this.Elevation = elevation;
        this.Status = status;
    }

    public long getTimeUTCMillis() {
        return System.currentTimeMillis() - SystemClock.elapsedRealtime() + this.timestamp;
    }

    public long getElapsedRealtimeMillis() {
        return this.timestamp;
    }

    private LineSegmentConstraint(Parcel in) {
        this.timestamp = in.readLong();
        this.StartLatitude = in.readDouble();
        this.StartLongitude = in.readDouble();
        this.EndLatitude = in.readDouble();
        this.EndLongitude = in.readDouble();
        this.LocationError = in.readFloat();
        this.Elevation = new ElevationInfo(in);
        this.Status = SegmentStatus.values()[in.readInt()];
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.timestamp);
        dest.writeDouble(this.StartLatitude);
        dest.writeDouble(this.StartLongitude);
        dest.writeDouble(this.EndLatitude);
        dest.writeDouble(this.EndLongitude);
        dest.writeFloat(this.LocationError);
        this.Elevation.writeToParcel(dest, flags);
        dest.writeInt(this.Status.ordinal());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Manual Constraint: ");
        sb.append("Time: ");
        sb.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault()).format(new Date(this.getTimeUTCMillis())));
        sb.append(" Start Location: (" + this.StartLatitude + ", " + this.StartLongitude + ")");
        sb.append(" End Location: (" + this.EndLatitude + ", " + this.EndLongitude + ")");
        sb.append(" Location Error: " + this.LocationError + " m");
        sb.append(" " + this.Elevation);
        sb.append(" Segment Status: " + (Object)((Object)this.Status));
        return sb.toString();
    }

    public static enum SegmentStatus {
        StartSegment,
        EndSegment;

    }
}

