/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonBeta.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class DebugLocation
implements Parcelable {
    public final long ElapsedRealTimeMs;
    public final double Latitude;
    public final double Longitude;
    public final Float Floor;
    public final Float Altitude;
    public static final Parcelable.Creator<DebugLocation> CREATOR = new Parcelable.Creator<DebugLocation>(){

        public DebugLocation createFromParcel(Parcel in) {
            return new DebugLocation(in);
        }

        public DebugLocation[] newArray(int size) {
            return new DebugLocation[size];
        }
    };
    private static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());

    public long GetUnixTimeMs() {
        return this.ElapsedRealTimeMs + System.currentTimeMillis() - SystemClock.elapsedRealtime();
    }

    public DebugLocation(long unixTimeMs, double latitude, double longitude, Float floor, Float altitude) {
        this.ElapsedRealTimeMs = SystemClock.elapsedRealtime() - System.currentTimeMillis() + unixTimeMs;
        this.Latitude = latitude;
        this.Longitude = longitude;
        this.Floor = floor;
        this.Altitude = altitude;
        if (!this.isValid()) {
            throw new IllegalArgumentException();
        }
    }

    private DebugLocation(Parcel in) {
        this.ElapsedRealTimeMs = in.readLong();
        this.Longitude = in.readDouble();
        this.Latitude = in.readDouble();
        this.Floor = in.readByte() > 0 ? Float.valueOf(in.readFloat()) : null;
        this.Altitude = in.readByte() > 0 ? Float.valueOf(in.readFloat()) : null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.ElapsedRealTimeMs);
        dest.writeDouble(this.Longitude);
        dest.writeDouble(this.Latitude);
        dest.writeByte((byte)(this.Floor != null ? 1 : 0));
        if (this.Floor != null) {
            dest.writeFloat(this.Floor.floatValue());
        }
        dest.writeByte((byte)(this.Altitude != null ? 1 : 0));
        if (this.Altitude != null) {
            dest.writeFloat(this.Altitude.floatValue());
        }
    }

    public boolean isValid() {
        if (!(this.Longitude >= -180.0) || !(this.Longitude <= 180.0)) {
            return false;
        }
        return this.Latitude >= -90.0 && this.Latitude <= 90.0;
    }

    public String toString() {
        String sb = "Time: " + DEFAULT_DATE_FORMAT.format(new Date(this.ElapsedRealTimeMs)) + ", " + "Longitude: " + this.Longitude + ", " + "Latitude: " + this.Latitude + ", " + "Floor: " + this.Floor + ", " + "Altitude: " + this.Altitude;
        return sb;
    }
}

