/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neon.model.events;

import android.os.Parcel;
import android.os.Parcelable;
import com.trx.neon.api.neon.model.interfaces.INeonEvent;
import com.trx.neon.api.neon.model.types.NeonEventConstants;
import com.trx.neon.api.neon.model.types.NeonEventType;
import java.util.Date;

public final class PostureEvent
implements Parcelable,
INeonEvent {
    public final long unixTimeMs;
    private final String type;
    public static final Parcelable.Creator<PostureEvent> CREATOR = new Parcelable.Creator<PostureEvent>(){

        public PostureEvent createFromParcel(Parcel in) {
            return new PostureEvent(in);
        }

        public PostureEvent[] newArray(int size) {
            return new PostureEvent[size];
        }
    };

    public PostureEventType getType() {
        try {
            return Enum.valueOf(PostureEventType.class, this.type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String getKey() {
        return NeonEventType.POSTURE.name();
    }

    @Override
    public NeonEventType getEventType() {
        return NeonEventType.POSTURE;
    }

    public PostureEvent(long unixTimeMs, PostureEventType type) {
        this.unixTimeMs = unixTimeMs;
        this.type = type.name();
    }

    private PostureEvent(Parcel in) {
        this.unixTimeMs = in.readLong();
        this.type = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.unixTimeMs);
        dest.writeString(this.type);
    }

    public String toString() {
        return "Time: " + NeonEventConstants.DEFAULT_DATE_FORMAT.format(new Date(this.unixTimeMs)) + ", " + "Type: " + this.type;
    }

    public static enum PostureEventType {
        UNKNOWN,
        UPRIGHT,
        ON_BACK,
        ON_FRONT,
        ON_SIDE_LEFT,
        ON_SIDE_RIGHT,
        UPSIDE_DOWN;

    }
}

