/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neon;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.trx.neon.api._internal.NeonImpl;
import com.trx.neon.api.neon.model.PositionConstraint;
import com.trx.neon.api.neon.model.interfaces.INeonEventListener;
import com.trx.neon.api.neon.model.interfaces.INeonLocationListener;
import com.trx.neon.api.neon.model.types.NeonEventType;
import com.trx.neon.api.neon.model.types.NeonLocationType;
import com.trx.neon.api.neonBeta.model.ElevationInfo;
import com.trx.neon.api.neonBeta.model.ManualConstraint;
import com.trx.neon.binder.OnLoginResult;
import java.util.EnumSet;

public class Neon {
    public static final String ACTIVITY_START_ON_TOUCH_PAIR = "com.trx.neon.framework.START_ON_TOUCH_PAIR";
    public static final String NEON_READY_ON_TOUCH_PAIR = "com.trx.neon.framework.NEON_READY_ON_TOUCH_PAIR";
    public static final String ACTIVITY_SETTINGS = "com.trx.neon.framework.settings.SETTINGS";

    public static void registerLocationUpdates(INeonLocationListener listener) {
        Neon.registerLocationUpdates(listener, NeonLocationType.CURRENT, "no tag");
    }

    public static void registerLocationUpdates(INeonLocationListener listener, NeonLocationType type) {
        NeonImpl.neon.registerLocationUpdates(listener, type, "no tag");
    }

    public static void registerLocationUpdates(INeonLocationListener listener, String tag) {
        Neon.registerLocationUpdates(listener, NeonLocationType.CURRENT, tag);
    }

    public static void registerLocationUpdates(INeonLocationListener listener, NeonLocationType type, String tag) {
        NeonImpl.neon.registerLocationUpdates(listener, type, tag);
    }

    public static void registerEvents(INeonEventListener listener) {
        Neon.registerEvents(listener, EnumSet.allOf(NeonEventType.class));
    }

    private static void registerEvents(INeonEventListener listener, EnumSet<NeonEventType> events) {
        NeonImpl.neon.registerEvents(listener, events);
    }

    public static boolean isNeonInstalled(Context c) {
        return NeonImpl.isNeonServiceInstalled(c);
    }

    public static boolean bind(Context c) {
        return Neon.bind(c, new Handler(Looper.getMainLooper()));
    }

    public static boolean bind(Context c, Handler eventHandler) {
        return NeonImpl.neon.bind(c, eventHandler);
    }

    public static void login(Account account, OnLoginResult onLoginResult) {
        NeonImpl.neon.login(account, onLoginResult);
    }

    public static void addConstraint(PositionConstraint constraint) {
        NeonImpl.checkLocation(constraint.getLatitude(), constraint.getLongitude());
        NeonImpl.neon.addManualConstraint(new ManualConstraint(constraint.getLatitude(), constraint.getLongitude(), constraint.getError(), ElevationInfo.None()));
    }

    public static boolean unregisterLocationUpdates(INeonLocationListener listener) {
        return NeonImpl.neon.unregisterLocationUpdates(listener);
    }

    public static boolean unregisterEvents(INeonEventListener listener) {
        return NeonImpl.neon.unregisterEvents(listener);
    }

    public static void unbind() {
        NeonImpl.neon.unbind();
    }

    public static String getLocationServiceVersion(Context c) {
        return NeonImpl.neon.getLocationServiceVersion(c);
    }

    public static void upgradeNeonLocationServices(Activity visibleActivity) {
        NeonImpl.neon.upgradeNeonLocationServices(visibleActivity);
    }

    public static void upgradeNeonLocationServices(Activity visibleActivity, boolean mandatoryUpdate) {
        NeonImpl.neon.upgradeNeonLocationServices(visibleActivity, mandatoryUpdate);
    }

    public static void upgradeDeviceFirmware(Activity visibleActivity) {
        NeonImpl.neon.upgradeDeviceFirmware(visibleActivity);
    }

    public static void upgradeDeviceFirmware(Activity visibleActivity, int requestCode) {
        NeonImpl.neon.upgradeDeviceFirmware(visibleActivity, requestCode);
    }

    public static boolean startLoginActivityForResult(int requestCode, Activity visibleActivity, boolean forceLogOut) {
        return NeonImpl.neon.startLoginActivityForResult(requestCode, visibleActivity, forceLogOut);
    }
}

