/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api._internal.legacy;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.trx.neon.api._internal.legacy.AltitudeConstraint;
import com.trx.neon.api._internal.legacy.ErrorModel;
import com.trx.neon.api._internal.legacy.FloorConstraint;
import com.trx.neon.api.neonBeta.model.PositionConstraint;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

@Deprecated
public class NeonConstraint
implements Parcelable {
    private static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
    private final long timestamp;
    private final PositionConstraint pos;
    private FloorConstraint floor;
    private AltitudeConstraint altitude;
    public static final Parcelable.Creator<NeonConstraint> CREATOR = new Parcelable.Creator<NeonConstraint>(){

        public NeonConstraint createFromParcel(Parcel in) {
            return new NeonConstraint(in);
        }

        public NeonConstraint[] newArray(int size) {
            return new NeonConstraint[size];
        }
    };

    public NeonConstraint(double latitude, double longitude) {
        this(latitude, longitude, System.currentTimeMillis(), ErrorModel.uniform(1.0f));
    }

    public NeonConstraint(double latitude, double longitude, long unixTimeMs, ErrorModel errorModel) {
        this(SystemClock.elapsedRealtime() - System.currentTimeMillis() + unixTimeMs, new PositionConstraint(latitude, longitude, errorModel));
    }

    public NeonConstraint withFloor(Integer floorNumber) {
        Float f = null;
        if (floorNumber != null) {
            f = Float.valueOf(floorNumber.intValue());
        }
        this.floor = f == null ? null : new FloorConstraint(floorNumber.intValue(), ErrorModel.uniform(0.1f));
        return this;
    }

    public NeonConstraint withAltitude(Float absoluteAltitude, ErrorModel model) {
        this.altitude = absoluteAltitude == null ? null : new AltitudeConstraint(absoluteAltitude.floatValue(), model);
        return this;
    }

    public long getTimeUTCMillis() {
        return System.currentTimeMillis() - SystemClock.elapsedRealtime() + this.timestamp;
    }

    public long getElapsedRealtimeMillis() {
        return this.timestamp;
    }

    public PositionConstraint getPosition() {
        return this.pos;
    }

    public FloorConstraint getFloor() {
        return this.floor;
    }

    public AltitudeConstraint getAltitude() {
        return this.altitude;
    }

    private NeonConstraint(long elapsedRealtimeMs, PositionConstraint pc) {
        this.timestamp = elapsedRealtimeMs;
        this.pos = pc;
        if (!this.isValid()) {
            throw new IllegalArgumentException("Latitude must be in the range -90 to 90, and Longitude must be in the range -180 to 180");
        }
    }

    private NeonConstraint(Parcel in) {
        this.timestamp = in.readLong();
        this.pos = new PositionConstraint(in);
        this.floor = in.readByte() > 0 ? new FloorConstraint(in) : null;
        this.altitude = in.readByte() > 0 ? new AltitudeConstraint(in) : null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.timestamp);
        this.pos.writeToParcel(dest, flags);
        dest.writeByte(this.floor == null ? (byte)0 : 1);
        if (this.floor != null) {
            this.floor.writeToParcel(dest, flags);
        }
        dest.writeByte(this.altitude == null ? (byte)0 : 1);
        if (this.altitude != null) {
            this.altitude.writeToParcel(dest, flags);
        }
    }

    public boolean isValid() {
        if (this.pos == null) {
            return false;
        }
        if (!(this.pos.getLongitude() >= -180.0) || !(this.pos.getLongitude() <= 180.0)) {
            return false;
        }
        return this.pos.getLatitude() >= -90.0 && this.pos.getLatitude() <= 90.0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("User Correction: ");
        sb.append("Time: ");
        sb.append(DEFAULT_DATE_FORMAT.format(new Date(this.getTimeUTCMillis())));
        sb.append(", Position: [");
        sb.append(this.pos);
        sb.append("], Floor: [");
        if (this.floor == null) {
            sb.append("NULL");
        } else {
            sb.append(this.floor);
        }
        sb.append("], Altitude: [");
        if (this.altitude == null) {
            sb.append("NULL");
        } else {
            sb.append(this.altitude);
        }
        sb.append("]");
        return sb.toString();
    }
}

