/******************************************************************************
 *
 * 	 Copyright 2017, TRX Systems, Inc.  All Rights Reserved.
 *
 *   TRX Systems, Inc.
 *   7500 Greenway Center Drive, Suite 420
 *   Greenbelt, Maryland  20770
 *
 *   Tel:    (301) 313-0053
 *   email:  info@trxsystems.com
 *
 *****************************************************************************/
package com.trx.neon.api.neonRouting.model.interfaces;

import com.trx.neon.api.neonRouting.model.Route;

/** Returns a Route and result status */
public interface INeonRouteListener {
	enum RoutingResult {
		/** routing to node was successful */
		SUCCESS,
		/** It is not possible to route to this node */
		NO_ROUTE_FOUND,
	}
	/** Will be called when NeonLocationService has had some sort of result */
	void onComplete(Route route, RoutingResult result);
}