/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonBeta.model.events;

import android.os.Parcel;
import android.os.Parcelable;
import com.trx.neon.api.neon.model.types.NeonEventConstants;
import com.trx.neon.api.neonBeta.model.interfaces.INeonEventBeta;
import java.util.Date;

public final class RemoteRangeEvent
implements Parcelable,
INeonEventBeta {
    public final long unixTimeMs;
    private final String type;
    public final String remoteDeviceID;
    public final float range;
    public static final Parcelable.Creator<RemoteRangeEvent> CREATOR = new Parcelable.Creator<RemoteRangeEvent>(){

        public RemoteRangeEvent createFromParcel(Parcel in) {
            return new RemoteRangeEvent(in);
        }

        public RemoteRangeEvent[] newArray(int size) {
            return new RemoteRangeEvent[size];
        }
    };

    public RemoteRangeEventType getType() {
        try {
            return Enum.valueOf(RemoteRangeEventType.class, this.type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public RemoteRangeEvent(long unixTimeMs, RemoteRangeEventType type, String remoteDeviceID, float range) {
        this.unixTimeMs = unixTimeMs;
        this.type = type.name();
        this.remoteDeviceID = remoteDeviceID;
        this.range = range;
    }

    private RemoteRangeEvent(Parcel in) {
        this.unixTimeMs = in.readLong();
        this.type = in.readString();
        this.remoteDeviceID = in.readString();
        this.range = in.readFloat();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.unixTimeMs);
        dest.writeString(this.type);
        dest.writeString(this.remoteDeviceID);
        dest.writeFloat(this.range);
    }

    public String toString() {
        return "Time: " + NeonEventConstants.DEFAULT_DATE_FORMAT.format(new Date(this.unixTimeMs)) + ", " + "Type: " + this.type + ", " + "ID: " + this.remoteDeviceID + ", " + "Range: " + this.range;
    }

    public static enum RemoteRangeEventType {
        BLE,
        UWB;

    }
}

