/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonBeta.model.events;

import android.os.Parcel;
import android.os.Parcelable;
import com.trx.neon.api.neon.model.types.NeonEventConstants;
import com.trx.neon.api.neonBeta.model.interfaces.INeonEventBeta;
import java.util.Date;

public final class CalibrationEvent
implements Parcelable,
INeonEventBeta {
    private final long unixTimeMs;
    public final String type;
    public static final Parcelable.Creator<CalibrationEvent> CREATOR = new Parcelable.Creator<CalibrationEvent>(){

        public CalibrationEvent createFromParcel(Parcel in) {
            return new CalibrationEvent(in);
        }

        public CalibrationEvent[] newArray(int size) {
            return new CalibrationEvent[size];
        }
    };

    public CalibrationEventType getType() {
        try {
            return Enum.valueOf(CalibrationEventType.class, this.type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public CalibrationEvent(long unixTimeMs, CalibrationEventType type) {
        this.unixTimeMs = unixTimeMs;
        this.type = type.name();
    }

    private CalibrationEvent(Parcel in) {
        this.unixTimeMs = in.readLong();
        this.type = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.unixTimeMs);
        dest.writeString(this.type);
    }

    public String toString() {
        return "Time: " + NeonEventConstants.DEFAULT_DATE_FORMAT.format(new Date(this.unixTimeMs)) + ", " + "Type: " + this.type;
    }

    public static enum CalibrationEventType {
        GYROSCOPE,
        MAGNETOMETER;

    }
}

