/*
 * Decompiled with CFR 0.152.
 */
package com.trx.neon.api.neonBeta.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.trx.neon.api.neonBeta.model.ElevationInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ManualConstraint
implements Parcelable {
    private final long timestamp;
    public final double Latitude;
    public final double Longitude;
    public final float LocationError;
    public final ElevationInfo Elevation;
    public final boolean Broadcast;
    public static final Parcelable.Creator<ManualConstraint> CREATOR = new Parcelable.Creator<ManualConstraint>(){

        public ManualConstraint createFromParcel(Parcel in) {
            return new ManualConstraint(in);
        }

        public ManualConstraint[] newArray(int size) {
            return new ManualConstraint[size];
        }
    };

    public ManualConstraint(double latitude, double longitude, float locationError, ElevationInfo elevation) {
        this(System.currentTimeMillis(), latitude, longitude, locationError, elevation, false);
    }

    public ManualConstraint(long unixTimeMs, double latitude, double longitude, float locationError, ElevationInfo elevation) {
        this(unixTimeMs, latitude, longitude, locationError, elevation, false);
    }

    public ManualConstraint(long unixTimeMs, double latitude, double longitude, float locationError, ElevationInfo elevation, boolean broadcast) {
        this.timestamp = SystemClock.elapsedRealtime() - System.currentTimeMillis() + unixTimeMs;
        this.Latitude = latitude;
        this.Longitude = longitude;
        this.LocationError = locationError;
        this.Elevation = elevation;
        this.Broadcast = broadcast;
    }

    public long getTimeUTCMillis() {
        return System.currentTimeMillis() - SystemClock.elapsedRealtime() + this.timestamp;
    }

    public long getElapsedRealtimeMillis() {
        return this.timestamp;
    }

    private ManualConstraint(Parcel in) {
        this.timestamp = in.readLong();
        this.Latitude = in.readDouble();
        this.Longitude = in.readDouble();
        this.LocationError = in.readFloat();
        this.Elevation = new ElevationInfo(in);
        this.Broadcast = in.readByte() > 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.timestamp);
        dest.writeDouble(this.Latitude);
        dest.writeDouble(this.Longitude);
        dest.writeFloat(this.LocationError);
        this.Elevation.writeToParcel(dest, flags);
        dest.writeByte(this.Broadcast ? (byte)1 : 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Manual Constraint: ");
        sb.append("Time: ");
        sb.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault()).format(new Date(this.getTimeUTCMillis())));
        sb.append(" Location: (" + this.Latitude + ", " + this.Longitude + ")");
        sb.append(" Location Error: " + this.LocationError + " m");
        sb.append(" " + this.Elevation);
        sb.append(" Broadcast: " + this.Broadcast);
        return sb.toString();
    }
}

