/******************************************************************************
 *
 * 	 Copyright 2017, TRX Systems, Inc.  All Rights Reserved.
 *
 *   TRX Systems, Inc.
 *   7500 Greenway Center Drive, Suite 420
 *   Greenbelt, Maryland  20770
 *
 *   Tel:    (301) 313-0053
 *   email:  info@trxsystems.com
 *
 *****************************************************************************/
package com.trx.neon.api.neonRouting.model.types;

import android.os.Parcel;
import android.os.Parcelable;

/**
 *
 * @author Travis
 *
 */
public enum RouteState implements Parcelable
{
	/** Current state of routing */
	LOADING,
	NOT_STARTED,
	IN_PROGRESS,
	FINISHED;

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeInt(ordinal());
	}

	@Override
	public int describeContents() {
		return 0;
	}

	public static final Creator<RouteState> CREATOR = new Creator<RouteState>() {
		@Override
		public RouteState createFromParcel(Parcel in) {
			int value = in.readInt();

			if(value >= RouteState.values().length)
				return RouteState.values()[0];
			return RouteState.values()[value];
		}

		@Override
		public RouteState[] newArray(int size) {
			return new RouteState[size];
		}
	};
}
