package com.trx.neon.api.neonBeta;

import android.os.SystemClock;

import java.util.EnumSet;
import com.trx.neon.api.neon.Neon;
import com.trx.neon.api.neonBeta.model.DebugLocation;
import com.trx.neon.api.neonBeta.model.NeonInertialDelta;
import com.trx.neon.api.neonBeta.model.interfaces.INeonEventListenerBeta;
import com.trx.neon.api.neonBeta.model.types.NeonEventTypeBeta;
import com.trx.neon.api.neonBeta.model.GPSConstraint;
import com.trx.neon.api.neonBeta.model.LineSegmentConstraint;
import com.trx.neon.api.neonBeta.model.ManualConstraint;
import com.trx.neon.api.neonBeta.model.RangingConstraint;

import static com.trx.neon.api._internal.NeonImpl.checkLocation;
import static com.trx.neon.api._internal.NeonImpl.neon;

public class NeonBeta extends Neon
{
    public static void registerEventsBeta(INeonEventListenerBeta listener)
    {
        registerEventsBeta(listener, EnumSet.allOf(NeonEventTypeBeta.class));
    }

    private static void registerEventsBeta(INeonEventListenerBeta listener, EnumSet<NeonEventTypeBeta> events)
    {
        neon.registerEventsBeta(listener,  events);
    }

    public static boolean unregisterEventsBeta(INeonEventListenerBeta listener)
    {
        return neon.unregisterEventsBeta(listener);
    }

    /**
     * Add a ranging constraint to help solve the user's location
     **/
    public static void addRangingConstraint(RangingConstraint constraint) {
        checkLocation(constraint.Latitude, constraint.Longitude);
        neon.addRangingConstraint(constraint);
    }

    /**
     * Add a manual user correction to help solve the user's location
     **/
    public static void addManualConstraint(ManualConstraint constraint) {
        checkLocation(constraint.Latitude, constraint.Longitude);
        neon.addManualConstraint(constraint);
    }

    /**
     * Add a GPS constraint to help solve the user's location
     **/
    public static void addGPSConstraint(GPSConstraint constraint) {
        checkLocation(constraint.Latitude, constraint.Longitude);
        neon.addGPSConstraint(constraint);
    }

    /**
     * Add a line segment or path constraint to help solve the user's location
     **/
    public static void addLineSegmentConstraint(LineSegmentConstraint constraint) {
        checkLocation(constraint.StartLatitude, constraint.StartLongitude);
        checkLocation(constraint.EndLatitude, constraint.EndLongitude);
        neon.addLineSegmentConstraint(constraint);
    }

    /**
     * Process a InertialDelta
     */
    public static void processInertialDelta(NeonInertialDelta delta) {
        neon.processInertialDelta(delta);
    }

    public static void addDebugLocation(DebugLocation dl)
    {
        neon.addDebugLocation(dl);
    }

    /**
     * Returns the system time as used in Neon Location Service. This is usually equal to
     * System.currentTimeMillis(), but if the user changes the clock mid-run, it will still
     * increase smoothly as if the clock hadn't changed.
     * @return A time that can be directly compared with a NeonLocation.unixTimeMs
     */
    public static long getNeonTimeMs()
    {
        return SystemClock.elapsedRealtime() + neon.getElapsedRealtimeOffset();
    }

    /**
     * Returns the system time as used in Neon Location Service. This is usually equal to
     * System.currentTimeMillis(), but if the user changes the clock mid-run, it will still
     * increase smoothly as if the clock hadn't changed.
     * @return A time that can be directly compared with a NeonLocation.unixTimeMs
     */
    public static long getNeonTimeMs(long elapsedRealtime)
    {
        return elapsedRealtime + neon.getElapsedRealtimeOffset();
    }
}