/******************************************************************************
 * 		
 * 	 Copyright 2015, TRX Systems, Inc.  All Rights Reserved.
 * 
 *   TRX Systems, Inc.
 *   7500 Greenway Center Drive, Suite 420
 *   Greenbelt, Maryland  20770
 *   
 *   Tel:    (301) 313-0053
 *   email:  info@trxsystems.com
 * 
 *****************************************************************************/
package com.trx.neon.api.neon.model.events;

import android.os.Parcel;
import android.os.Parcelable;

import com.trx.neon.api.neon.model.interfaces.INeonEvent;
import com.trx.neon.api.neon.model.types.NeonEventConstants;
import com.trx.neon.api.neon.model.types.NeonEventType;

import java.util.Date;

/**
 * Represents the last time a resource was connected/disconnected.  
 * This can be used to determine server connectivity or tracking unit 
 * connectivity in the case of external tracking units.
 * @author Dan
 *
 */
public final class AuthenticationEvent implements Parcelable, INeonEvent
{
	/** Represents a type of resource that NeonLocationService must maintain a connection with */
	public enum AuthenticationEventType
	{
		/** There are no stored credentials, start activity to login to NLS */
		NO_CREDENTIALS_SET,
		/** NLS must be upgraded in order to log in */
		MANDATORY_UPDATE_REQUIRED,
		/** An error message was generated, direct user to NEON Settings page to resolve */
		UNRESOLVED_AUTHENTICATION_ERROR,
		/** Can't log in because there is no Internet access */
		NO_INTERNET,
		/** We have successfully logged in to the NLS */
		SUCCESS;
	}

	private final long unixTimeMs;
	private final String type;

	public AuthenticationEventType getType()
	{
		try
		{
			return Enum.valueOf(AuthenticationEventType.class, type);
		}
		catch (IllegalArgumentException e)
		{
			//Version mismatch with Neon Location Services?
			return null;
		}
	}

	public String getKey()
	{
		return type;
	}

	public NeonEventType getEventType()
	{
		return NeonEventType.AUTHENTICATION;
	}

	public AuthenticationEvent(long unixTimeMs, AuthenticationEventType type)
	{
		this.unixTimeMs = unixTimeMs;
		this.type = type.name();
	}

	private AuthenticationEvent(Parcel in)
	{
		this.unixTimeMs = in.readLong();
		this.type = in.readString();
	}

	/**
	 * Used for sending data across binders
	 */
	public static final Creator<AuthenticationEvent> CREATOR = new Creator<AuthenticationEvent>() {
		@Override
		public AuthenticationEvent createFromParcel(Parcel in) {
			return new AuthenticationEvent(in);
		}

		@Override
		public AuthenticationEvent[] newArray(int size) {
			return new AuthenticationEvent[size];
		}
	};	
	
	@Override
	public int describeContents() 
	{
		return 0;
	}
	
	@Override
	public void writeToParcel(Parcel dest, int flags) 
	{
		dest.writeLong(unixTimeMs);
		dest.writeString(type);
	}
	
	public String toString()
	{
		return ("Time: " + NeonEventConstants.DEFAULT_DATE_FORMAT.format(new Date(unixTimeMs)) + ", ") + "Type: " + type;
	}
}