/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.liveness.cw.st.widget.finder.childs;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Base64;
import android.view.View;

public class HollowedOutDetectingView
extends View {
    private int PAINT_STROKE_WIDTH = 4;
    private Path mPath;
    private Paint mPaint;
    private int mBackgroundColor = -65536;
    private Rect mHollowedOutRect = new Rect();
    private Rect mBoundingRectangle = new Rect();

    public HollowedOutDetectingView(Context context) {
        super(context);
        this.init();
    }

    public HollowedOutDetectingView(Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public HollowedOutDetectingView(Context context, @Nullable AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init();
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(0);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth((float)this.PAINT_STROKE_WIDTH);
        this.mPath = new Path();
        this.mBackgroundColor = -1;
    }

    public void setBackgroundColor(@ColorInt int n) {
        this.mBackgroundColor = n;
        this.invalidate();
    }

    public void setMaskPathColor(@ColorInt int n) {
        this.mPaint.setColor(n);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        this.mPath.reset();
        this.buildPath(this.mPath, this.getWidth(), this.getHeight());
        if (Build.VERSION.SDK_INT >= 26) {
            canvas.clipOutPath(this.mPath);
        } else if (Build.VERSION.SDK_INT >= 19) {
            canvas.clipPath(this.mPath, Region.Op.DIFFERENCE);
        }
        canvas.drawColor(this.mBackgroundColor);
        canvas.drawCircle((float)this.mBoundingRectangle.centerX(), (float)this.mBoundingRectangle.centerY(), (float)(this.mBoundingRectangle.width() / 2), this.mPaint);
        canvas.restore();
    }

    private void buildPath(@NonNull Path path, int n, int n2) {
        int n3 = Math.min(n - this.getPaddingLeft() - this.getPaddingRight(), n2 - this.getPaddingTop() - this.getPaddingBottom());
        this.mBoundingRectangle.set((n - n3) / 2, (n2 - n3) / 2, (n - n3) / 2 + n3, (n2 - n3) / 2 + n3);
        int n4 = (int)(1.2 * Math.sqrt(this.mBoundingRectangle.width() / 2 * (this.mBoundingRectangle.width() / 2) / 2));
        this.mHollowedOutRect.set(this.mBoundingRectangle.centerX() - n4, this.mBoundingRectangle.centerY() - n4, this.mBoundingRectangle.centerX() + n4, this.mBoundingRectangle.centerY() + n4);
        path.addCircle((float)this.mHollowedOutRect.centerX(), (float)this.mHollowedOutRect.centerY(), (float)(n3 / 2), Path.Direction.CCW);
    }

    public Rect getHollowedOutRect() {
        return this.mHollowedOutRect;
    }

    private static String linkxxxxx(String string2, int n) {
        try {
            int n2;
            int n3;
            int n4 = string2.length() / 2;
            char[] cArray = string2.toCharArray();
            byte[] byArray = new byte[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = n3 * 2;
                byArray[n3] = (byte)("0123456789abcdef".indexOf(cArray[n2]) << 4 | "0123456789abcdef".indexOf(cArray[n2 + 1]));
            }
            n3 = (byte)(n ^ 0x54);
            n2 = byArray.length;
            byArray[0] = (byte)(byArray[0] ^ 0x74);
            byte by = byArray[0];
            for (int i2 = 1; i2 < n2; ++i2) {
                byte by2 = byArray[i2];
                byArray[i2] = (byte)(byArray[i2] ^ by ^ n3);
                by = by2;
            }
            return new String(byArray, "utf-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String i1i1iI1I11iI(String string2) {
        try {
            byte[] byArray = Base64.decode((String)string2, (int)0);
            int n = byArray.length;
            byte[] byArray2 = "kijckQ".getBytes();
            int n2 = byArray2.length;
            for (int i2 = 0; i2 < n; ++i2) {
                byArray[i2] = (byte)(byArray[i2] ^ byArray2[i2 % n2]);
            }
            return new String(byArray, "utf-8");
        }
        catch (Exception exception) {
            return null;
        }
    }
}

