/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.liveness.cw.api.ui;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PorterDuff;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.Base64;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.BounceInterpolator;
import android.widget.ImageView;
import com.trustdecision.liveness.cw.R;
import com.trustdecision.liveness.cw.libproject.Builder;
import com.trustdecision.liveness.cw.libproject.LiveStartActivity;
import com.trustdecision.liveness.cw.libproject.LiveStartActivityLandscape;
import com.trustdecision.liveness.cw.libproject.base.CwBaseFragment;
import com.trustdecision.liveness.cw.libproject.callback.ResultPageCallback;
import com.trustdecision.liveness.cw.libproject.view.RoundImageView;
import com.trustdecision.liveness.cw.util.NoDoubleClickListener;

public class TDLiveResultFragment
extends CwBaseFragment {
    private MediaPlayer mediaPlayer;
    private AnimatorSet animatorSet;
    private int resultCode;
    private boolean isSuccess;
    private byte[] bestFace;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.resultCode = this.getArguments().getInt("result_code");
        this.bestFace = this.getArguments().getByteArray("best_face");
        this.isSuccess = this.resultCode == 618;
        View view = this.isSuccess ? layoutInflater.inflate(R.layout.td_fragment_live_result_success, viewGroup, false) : layoutInflater.inflate(R.layout.td_fragment_live_result_fail, viewGroup, false);
        this.initView(this.isSuccess, view);
        return view;
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
        if (this.animatorSet != null && this.animatorSet.isRunning()) {
            this.animatorSet.end();
        }
    }

    private void initView(boolean bl, View view) {
        if (bl) {
            Bitmap bitmap;
            byte[] byArray;
            View view2 = view.findViewById(R.id.td_live_result_pass);
            int n = Builder.getCwLiveConfig().getCwBaseUiConfig().getBtnBackColor();
            if (-1 != n) {
                view2.setBackgroundColor(n);
            }
            view2.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

                @Override
                public void onNoDoubleClick(View view) {
                    FragmentActivity fragmentActivity;
                    if (TDLiveResultFragment.this.mediaPlayer != null) {
                        TDLiveResultFragment.this.mediaPlayer.stop();
                        TDLiveResultFragment.this.mediaPlayer.reset();
                        TDLiveResultFragment.this.mediaPlayer.release();
                        TDLiveResultFragment.this.mediaPlayer = null;
                    }
                    if ((fragmentActivity = TDLiveResultFragment.this.getActivity()) == null) {
                        return;
                    }
                    TDLiveResultFragment.this.onResultPageFinish(722);
                    fragmentActivity.finish();
                }
            });
            RoundImageView roundImageView = (RoundImageView)view.findViewById(R.id.td_live_success_imageview);
            View view3 = view.findViewById(R.id.td_live_success_mask);
            ViewGroup.LayoutParams layoutParams = view3.getLayoutParams();
            ViewGroup.LayoutParams layoutParams2 = roundImageView.getLayoutParams();
            layoutParams2.width = layoutParams.width - 50;
            layoutParams2.height = layoutParams.height - 50;
            roundImageView.setLayoutParams(layoutParams2);
            byte[] byArray2 = byArray = Builder.serverBestFace != null ? Builder.serverBestFace : this.bestFace;
            if (byArray != null) {
                bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                if (bitmap != null) {
                    roundImageView.setImageBitmap(bitmap);
                } else {
                    roundImageView.setImageDrawable(this.getResources().getDrawable(R.color.td_white));
                }
            } else {
                roundImageView.setImageDrawable(this.getResources().getDrawable(R.color.td_white));
            }
            bitmap = view.findViewById(R.id.td_live_success_view);
            this.animatorSet = new AnimatorSet();
            ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)bitmap, (String)TDLiveResultFragment.i1i1iI1I11iI("OC8MIy4U"), (float[])new float[]{0.0f, 1.0f}).setDuration(1500L);
            ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)bitmap, (String)TDLiveResultFragment.i1i1iI1I11iI("OC8MIy4V"), (float[])new float[]{0.0f, 1.0f}).setDuration(1500L);
            this.animatorSet.setInterpolator((TimeInterpolator)new BounceInterpolator());
            this.animatorSet.play((Animator)objectAnimator).with((Animator)objectAnimator2);
            this.animatorSet.start();
            this.mediaPlayer = MediaPlayer.create((Context)this.getContext(), (int)R.raw.td_success);
        } else {
            View view4 = view.findViewById(R.id.td_live_restart);
            int n = Builder.getCwLiveConfig().getCwBaseUiConfig().getBtnBackColor();
            if (-1 != n) {
                view4.setBackgroundColor(n);
            }
            view4.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

                @Override
                public void onNoDoubleClick(View view) {
                    FragmentActivity fragmentActivity;
                    if (TDLiveResultFragment.this.mediaPlayer != null) {
                        TDLiveResultFragment.this.mediaPlayer.stop();
                        TDLiveResultFragment.this.mediaPlayer.reset();
                        TDLiveResultFragment.this.mediaPlayer.release();
                        TDLiveResultFragment.this.mediaPlayer = null;
                    }
                    if ((fragmentActivity = TDLiveResultFragment.this.getActivity()) == null) {
                        return;
                    }
                    TDLiveResultFragment.this.onResultPageFinish(720);
                    Builder.startActivity((Context)fragmentActivity, Builder.getCwLiveConfig().isLandscape() ? LiveStartActivityLandscape.class : LiveStartActivity.class);
                    fragmentActivity.finish();
                }
            });
            switch (this.getArguments().getInt("result_code")) {
                case 706: {
                    this.mediaPlayer = MediaPlayer.create((Context)this.getContext(), (int)R.raw.td_verfy_fail);
                    break;
                }
                case 703: {
                    this.mediaPlayer = MediaPlayer.create((Context)this.getContext(), (int)R.raw.td_failed_timeout);
                    break;
                }
                case 713: {
                    this.mediaPlayer = MediaPlayer.create((Context)this.getContext(), (int)R.raw.td_net_fail);
                    break;
                }
                default: {
                    this.mediaPlayer = MediaPlayer.create((Context)this.getContext(), (int)R.raw.td_failed);
                }
            }
            int n2 = this.getResources().getColor(R.color.td_black);
            ImageView imageView = (ImageView)view.findViewById(R.id.td_live_back);
            imageView.setColorFilter(n2, PorterDuff.Mode.SRC_ATOP);
            imageView.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

                @Override
                public void onNoDoubleClick(View view) {
                    TDLiveResultFragment.this.onBackPressed();
                }
            });
        }
        if (Builder.getCwLiveConfig().isPlaySound()) {
            this.mediaPlayer.start();
        }
    }

    private void onResultPageFinish(int n) {
        ResultPageCallback resultPageCallback = Builder.getCwLiveConfig().getResultPageCallback();
        if (resultPageCallback == null) {
            return;
        }
        resultPageCallback.onResultPageFinish(n, this.resultCode);
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        if (this.isSuccess) {
            this.onResultPageFinish(722);
        } else {
            this.onResultPageFinish(721);
        }
    }

    private static String linkxxxxx(String string2, int n) {
        try {
            int n2;
            int n3;
            int n4 = string2.length() / 2;
            char[] cArray = string2.toCharArray();
            byte[] byArray = new byte[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = n3 * 2;
                byArray[n3] = (byte)("0123456789abcdef".indexOf(cArray[n2]) << 4 | "0123456789abcdef".indexOf(cArray[n2 + 1]));
            }
            n3 = (byte)(n ^ 9);
            n2 = byArray.length;
            byArray[0] = (byte)(byArray[0] ^ 0x26);
            byte by = byArray[0];
            for (int i = 1; i < n2; ++i) {
                byte by2 = byArray[i];
                byArray[i] = (byte)(byArray[i] ^ by ^ n3);
                by = by2;
            }
            return new String(byArray, "utf-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String i1i1iI1I11iI(String string2) {
        try {
            byte[] byArray = Base64.decode((String)string2, (int)0);
            int n = byArray.length;
            byte[] byArray2 = "KLmO".getBytes();
            int n2 = byArray2.length;
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)(byArray[i] ^ byArray2[i % n2]);
            }
            return new String(byArray, "utf-8");
        }
        catch (Exception exception) {
            return null;
        }
    }
}

