/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.liveness.cw.libproject.camera;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.widget.FrameLayout;
import com.trustdecision.liveness.cw.R;
import com.trustdecision.liveness.cw.libproject.camera.AspectRatio;
import com.trustdecision.liveness.cw.libproject.camera.CwGLSurfaceCamera;
import com.trustdecision.liveness.cw.libproject.camera.CwVideoRecordView;
import com.trustdecision.liveness.cw.libproject.camera.ICameraView;
import com.trustdecision.liveness.cw.libproject.camera.Size;
import com.trustdecision.liveness.cw.util.DisplayOrientationDetector;
import com.trustdecision.liveness.cw.util.UiUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;

public class CwCameraView
extends FrameLayout {
    public static final int FLASH_OFF = 0;
    public static final int FLASH_ON = 1;
    public static final int FLASH_TORCH = 2;
    public static final int FLASH_AUTO = 3;
    public static final int FLASH_RED_EYE = 4;
    private static final int a = 40;
    private final CallbackBridge b;
    private DisplayOrientationDetector c;
    protected ICameraView d;
    private Bitmap e;
    private Paint f;
    private Rect g;
    private Path h;
    private RoundPreviewCallback i;
    private int j;

    public CwCameraView(Context context) {
        this(context, null);
    }

    public CwCameraView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CwCameraView(Context context, AttributeSet object, int n) {
        CallbackBridge callbackBridge;
        CwCameraView cwCameraView = this;
        super(context, object, n);
        if (cwCameraView.isInEditMode()) {
            CwCameraView cwCameraView2 = this;
            cwCameraView2.b = null;
            cwCameraView2.c = null;
            return;
        }
        AttributeSet attributeSet = object;
        object = callbackBridge;
        this.b = new CallbackBridge();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CwCameraView);
        String string2 = typedArray.getString(R.styleable.CwCameraView_cwImpl);
        this.d = !TextUtils.isEmpty((CharSequence)string2) && string2.contains("video") ? new CwVideoRecordView(this.getContext()) : new CwGLSurfaceCamera(this.getContext());
        CwCameraView cwCameraView3 = this;
        cwCameraView3.addView((View)cwCameraView3.d, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        cwCameraView3.d.setCallbackBridge((CallbackBridge)object);
        this.setFacing(typedArray.getInt(R.styleable.CwCameraView_cwFacing, 1));
        object = typedArray.getString(R.styleable.CwCameraView_cwPreviewSize);
        if (!TextUtils.isEmpty((CharSequence)object)) {
            if ("auto".equals(object)) {
                object = UiUtil.getScreenSize(context);
                if (this.getContext().getResources().getConfiguration().orientation == 2) {
                    this.setAspectRatio(AspectRatio.of(object.x, object.y));
                } else {
                    this.setAspectRatio(AspectRatio.of(object.y, object.x));
                }
            } else {
                this.setResolutionSize(Size.parse((String)object));
            }
        }
        this.j = typedArray.getInteger(R.styleable.CwCameraView_cwRoundPreviewPadding, 40);
        this.setAutoFocus(typedArray.getBoolean(R.styleable.CwCameraView_cwAutoFocus, true));
        typedArray.recycle();
        this.c = new DisplayOrientationDetector(context){

            @Override
            public void onDisplayOrientationChanged(int n) {
                CwCameraView.this.d.setDisplayOrientation(n);
            }
        };
    }

    @RequiresApi(api=21)
    private void a(final RoundPreviewCallback roundPreviewCallback) {
        ViewOutlineProvider viewOutlineProvider;
        CwCameraView cwCameraView = this;
        ViewOutlineProvider viewOutlineProvider2 = viewOutlineProvider;
        viewOutlineProvider = new ViewOutlineProvider(){

            public void getOutline(View view, Outline outline) {
                Rect rect;
                int n;
                int n2;
                int n3;
                View view2 = view;
                int n4 = view2.getMeasuredWidth();
                int n5 = view2.getMeasuredHeight();
                if (n5 >= n4) {
                    int n6 = n5;
                    n5 = 0;
                    n3 = (n6 - n4) / 2;
                    n2 = n6 - n3;
                    n = n4 / 2;
                    int n7 = n5;
                    int n8 = n3;
                    n5 = n2;
                    n3 = n4;
                    n2 = n8;
                    n4 = n7;
                } else {
                    int n9 = n4;
                    n4 = (n9 - n5) / 2;
                    n3 = n9 - n4;
                    int cfr_ignored_0 = n5 / 2;
                    n4 += 20;
                    n2 = 20;
                    n3 -= 20;
                    n = ((n5 += -20) - n2) / 2;
                }
                Outline outline2 = outline;
                outline = rect;
                int n10 = n5;
                int n11 = n4 + CwCameraView.this.j;
                n4 = n2 + CwCameraView.this.j;
                n5 = n3 - CwCameraView.this.j;
                n3 = n10 - CwCameraView.this.j;
                rect = new Rect(n11, n4, n5, n3);
                n11 = n - CwCameraView.this.j;
                outline2.setRoundRect((Rect)outline, (float)n11);
                RoundPreviewCallback roundPreviewCallback2 = roundPreviewCallback;
                if (roundPreviewCallback2 != null) {
                    roundPreviewCallback2.onRoundPreview((Rect)outline, n11);
                }
            }
        };
        cwCameraView.setOutlineProvider(viewOutlineProvider2);
        cwCameraView.setClipToOutline(true);
    }

    private Bitmap a() {
        Matrix matrix;
        Matrix matrix2 = matrix;
        matrix2();
        matrix.postScale((float)this.g.width() * 1.0f / (float)this.e.getWidth(), (float)this.g.height() * 1.0f / (float)this.e.getHeight());
        Bitmap bitmap = this.e;
        int n = bitmap.getWidth();
        int n2 = this.e.getHeight();
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix2, (boolean)true);
        this.e.recycle();
        this.e = null;
        return bitmap2;
    }

    public ICameraView getImpl() {
        return this.d;
    }

    public void requestCapture() {
        Object object = object.d;
        if (object instanceof CwGLSurfaceCamera) {
            ((CwGLSurfaceCamera)object).requestCapture();
        }
    }

    protected void onAttachedToWindow() {
        CwCameraView cwCameraView = this;
        super.onAttachedToWindow();
        if (!cwCameraView.isInEditMode()) {
            this.c.enable(ViewCompat.getDisplay((View)this));
        }
    }

    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.c.disable();
        }
        this.c = null;
        super.onDetachedFromWindow();
    }

    public void start() {
        if (!this.d.start()) {
            CwCameraView cwCameraView = this;
            cwCameraView.onRestoreInstanceState(cwCameraView.onSaveInstanceState());
            cwCameraView.d.start();
        }
    }

    public void stop() {
        this.d.stop();
    }

    public void pausePreview() {
        Object object = object.d;
        if (object instanceof CwGLSurfaceCamera) {
            ((CwGLSurfaceCamera)object).stopCameraPreview();
        }
    }

    public void resumePreview() {
        Object object = object.d;
        if (object instanceof CwGLSurfaceCamera) {
            ((CwGLSurfaceCamera)object).resumeCameraPreview();
        }
    }

    public void focus() {
        this.d.foucs();
    }

    public boolean isCameraOpened() {
        return this.d.isCameraOpened();
    }

    public void addCallback(Callback callback) {
        this.b.add(callback);
    }

    public void removeCallback(Callback callback) {
        this.b.remove(callback);
    }

    protected CallbackBridge getCallbacks() {
        return this.b;
    }

    public int getFacing() {
        return this.d.getFacing();
    }

    public void setFacing(int n) {
        this.d.setFacing(n);
    }

    public void setAspectRatio(AspectRatio aspectRatio) {
        this.d.setAspectRatio(aspectRatio);
    }

    public Size getResolutionSize() {
        return this.d.getResolutionSize();
    }

    public void setResolutionSize(Size size) {
        this.d.setResolutionSize(size);
    }

    public boolean getAutoFocus() {
        return this.d.getAutoFocus();
    }

    public void setAutoFocus(boolean bl) {
        this.d.setAutoFocus(bl);
    }

    public boolean setFlashOpen(boolean bl) {
        return this.d.setFlashOpen(bl);
    }

    public String getFlashMode() {
        return this.d.getFlashMode();
    }

    public int getDisplayOrientation() {
        return this.c.getLastKnownDisplayOrientation();
    }

    public void takePicture() {
        this.d.takePicture();
    }

    protected void a(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
    }

    public void roundPreview(int n, int n2, RoundPreviewCallback roundPreviewCallback) {
        this.i = roundPreviewCallback;
        if (Build.VERSION.SDK_INT >= 21) {
            this.a(roundPreviewCallback);
        } else {
            this.roundPreviewLowAndroidVersion(n, n2, roundPreviewCallback);
        }
    }

    public void roundPreviewLowAndroidVersion(int n, int n2, RoundPreviewCallback roundPreviewCallback) {
        Paint paint;
        Paint paint2;
        CwCameraView cwCameraView = this;
        cwCameraView.i = roundPreviewCallback;
        cwCameraView.e = BitmapFactory.decodeResource((Resources)cwCameraView.getResources(), (int)n);
        Paint paint3 = paint2 = paint;
        paint3();
        this.f = paint3;
        paint.setColor(this.getResources().getColor(n2));
        cwCameraView.invalidate();
    }

    public void setLowAndroidVersionMask(int n, int n2) {
        CwCameraView cwCameraView = this;
        cwCameraView.e = BitmapFactory.decodeResource((Resources)cwCameraView.getResources(), (int)n);
        Rect rect = cwCameraView.g;
        if (rect != null && !rect.isEmpty()) {
            this.e = this.a();
        }
        if (this.f == null) {
            Paint paint;
            rect = paint;
            paint = new Paint();
            this.f = rect;
        }
        CwCameraView cwCameraView2 = this;
        cwCameraView2.f.setColor(n2);
        cwCameraView2.invalidate();
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        CwCameraView cwCameraView = this;
        super.onSizeChanged(n, n2, n3, n4);
        if (cwCameraView.e != null && this.f != null) {
            Path path;
            int n5;
            if (n2 >= n) {
                int n6 = n2;
                n2 = 0;
                n3 = (n6 - n) / 2;
                n4 = n6 - n3;
                n5 = n / 2;
                int n7 = n2;
                int n8 = n3;
                n2 = n4;
                n3 = n;
                n4 = n8;
                n = n7;
            } else {
                int n9 = n;
                n = (n9 - n2) / 2;
                n3 = n9 - n;
                int cfr_ignored_0 = n2 / 2;
                n += 20;
                n4 = 20;
                n3 -= 20;
                n5 = ((n2 += -20) - n4) / 2;
            }
            CwCameraView cwCameraView2 = this;
            int n10 = n2;
            int n11 = n3;
            int n12 = n;
            n = this.j;
            n2 = n12 + n;
            n3 = n4 + n;
            n4 = n11 - n;
            n = n10 - n;
            this.g = new Rect(n2, n3, n4, n);
            n = n5 - this.j;
            Path path2 = path;
            CwCameraView cwCameraView3 = this;
            Path path3 = path2;
            path3();
            cwCameraView3.h = path3;
            float f2 = cwCameraView3.g.centerX();
            float f3 = cwCameraView3.g.centerY();
            float f4 = n;
            Object object = Path.Direction.CCW;
            path.addCircle(f2, f3, f4, (Path.Direction)object);
            cwCameraView2.e = cwCameraView2.a();
            object = cwCameraView2.i;
            if (object != null) {
                object.onRoundPreview(this.g, n);
            }
            return;
        }
    }

    protected boolean drawChild(Canvas canvas, View view, long l) {
        if (cwCameraView2.e != null && cwCameraView2.g != null && cwCameraView2.f != null) {
            Canvas canvas2 = canvas;
            canvas2.clipPath(cwCameraView2.h);
            boolean bl = super.drawChild(canvas2, view, l);
            CwCameraView cwCameraView = cwCameraView2;
            CwCameraView cwCameraView2 = cwCameraView.e;
            Rect rect = cwCameraView.g;
            float f2 = rect.left;
            float f3 = rect.top;
            Paint paint = cwCameraView.f;
            canvas.drawBitmap((Bitmap)cwCameraView2, f2, f3, paint);
            return bl;
        }
        return super.drawChild(canvas, view, l);
    }

    public int getPreviewAngle() {
        return this.d.getPreviewAngle();
    }

    public int getPreviewMirror() {
        return this.d.getPreviewMirror();
    }

    protected class CallbackBridge {
        private final ArrayList<Callback> a;
        private boolean b;

        CallbackBridge() {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            v1.a = arrayList2;
        }

        public void add(Callback callback) {
            this.a.add(callback);
        }

        public void remove(Callback callback) {
            this.a.remove(callback);
        }

        public void onCameraOpened() {
            if (this.b) {
                this.b = false;
                CwCameraView.this.requestLayout();
            }
            Iterator<Callback> iterator = this.a.iterator();
            while (iterator.hasNext()) {
                iterator.next().onCameraOpened(CwCameraView.this);
            }
        }

        public void onCameraClosed() {
            Iterator<Callback> iterator = this.a.iterator();
            while (iterator.hasNext()) {
                iterator.next().onCameraClosed(CwCameraView.this);
            }
        }

        public void onCameraCapture(byte[] byArray, int[] nArray, int n, int n2) {
            Iterator<Callback> iterator = ((CallbackBridge)((Object)iterator)).a.iterator();
            while (iterator.hasNext()) {
                ((Callback)iterator.next()).onCameraCapture(byArray, nArray, n, n2);
            }
        }

        public void onPictureTaken(byte[] byArray) {
            Iterator<Callback> iterator = this.a.iterator();
            while (iterator.hasNext()) {
                iterator.next().onPictureTaken(CwCameraView.this, byArray);
            }
        }

        public void onPreviewFrame(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
            CallbackBridge callbackBridge = this;
            callbackBridge.CwCameraView.this.a(byArray, n, n2, n3, n4, n5);
            Iterator<Callback> iterator = callbackBridge.a.iterator();
            while (iterator.hasNext()) {
                iterator.next().onPreviewFrame(CwCameraView.this, byArray, n, n2, n3, n4, n5);
            }
        }

        public void reserveRequestLayoutOnOpen() {
            this.b = true;
        }
    }

    public static abstract class Callback {
        public void onCameraOpened(CwCameraView cwCameraView) {
        }

        public void onCameraClosed(CwCameraView cwCameraView) {
        }

        public void onCameraCapture(byte[] byArray, int[] nArray, int n, int n2) {
        }

        public void onPictureTaken(CwCameraView cwCameraView, byte[] byArray) {
        }

        public void onPreviewFrame(CwCameraView cwCameraView, byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        }
    }

    public static interface RoundPreviewCallback {
        public void onRoundPreview(Rect var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flash {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Facing {
    }
}

