/*
 * Decompiled with CFR 0.152.
 */
package com.trustdecision.liveness.cw.libproject.base;

import android.app.ActionBar;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.trustdecision.liveness.cw.R;
import com.trustdecision.liveness.cw.libproject.Builder;
import com.trustdecision.liveness.cw.libproject.base.CwBaseFragment;
import com.trustdecision.liveness.cw.libproject.dialog.LiveTimeOutDialog;
import com.trustdecision.liveness.cw.libproject.dialog.OnDialogClickListener;
import com.trustdecision.liveness.cw.util.NoDoubleClickListener;
import com.trustdecision.liveness.cw.util.TranslucentStatusUtil;
import com.trustdecision.liveness.cw.util.UiUtil;
import java.util.ArrayList;
import java.util.Locale;

public class CwBaseActivity
extends FragmentActivity {
    private static final int REQUEST_CODE = 136;
    private static final String[] PERMISSIONS = new String[]{"android.permission.CAMERA"};
    private final View.OnClickListener listener;
    private LinearLayout mContainer;
    private View mActionBar;
    private TextView mActionBarTitle;
    private ImageView mActionBarLeftButton;
    private ImageView mActionBarRightButton;
    private LiveTimeOutDialog permissioDialog;

    public CwBaseActivity() {
        NoDoubleClickListener noDoubleClickListener;
        NoDoubleClickListener noDoubleClickListener2 = noDoubleClickListener;
        noDoubleClickListener = new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View view) {
                int n = view.getId();
                if (n == R.id.cw_action_bar_left_image) {
                    CwBaseActivity.this.onLeftClick(view);
                } else if (n == R.id.cw_action_bar_right_image) {
                    CwBaseActivity.this.onRightClick(view);
                }
            }
        };
        this.listener = noDoubleClickListener2;
    }

    protected boolean hasActionBar() {
        return true;
    }

    public void setContentView(int n) {
        if (cwBaseActivity3.hasActionBar()) {
            LinearLayout.LayoutParams layoutParams;
            CwBaseActivity cwBaseActivity = cwBaseActivity3;
            CwBaseActivity cwBaseActivity2 = cwBaseActivity3 = cwBaseActivity.getLayoutInflater().inflate(n, null);
            CwBaseActivity cwBaseActivity3 = layoutParams;
            layoutParams = new LinearLayout.LayoutParams(-1, -1);
            cwBaseActivity.mContainer.addView((View)cwBaseActivity2, (ViewGroup.LayoutParams)cwBaseActivity3);
            super.setContentView((View)cwBaseActivity.mContainer);
        } else {
            super.setContentView(n);
        }
    }

    protected void onCreate(Bundle bundle) {
        Configuration configuration;
        super.onCreate(bundle);
        if (Builder.getCwLiveConfig().isSecureOn()) {
            this.getWindow().setFlags(8192, 8192);
        }
        CwBaseActivity cwBaseActivity = this;
        TranslucentStatusUtil.translucentStatusBar((Activity)cwBaseActivity, true);
        TranslucentStatusUtil.setTextDark((Context)cwBaseActivity, true);
        Resources resources = cwBaseActivity.getResources();
        bundle = configuration;
        new Configuration().setToDefaults();
        resources.updateConfiguration((Configuration)bundle, resources.getDisplayMetrics());
        if (cwBaseActivity.hasActionBar()) {
            CwBaseActivity cwBaseActivity2 = this;
            this.mContainer = new LinearLayout((Context)this);
            this.mContainer.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            cwBaseActivity2.mContainer.setOrientation(1);
            this.mActionBar = cwBaseActivity2.getLayoutInflater().inflate(R.layout.cw_actionbar_layout, null);
            cwBaseActivity2.mActionBarTitle = (TextView)this.mActionBar.findViewById(R.id.cw_action_bar_title);
            cwBaseActivity2.mActionBarLeftButton = (ImageView)cwBaseActivity2.mActionBar.findViewById(R.id.cw_action_bar_left_image);
            cwBaseActivity2.mActionBarRightButton = (ImageView)cwBaseActivity2.mActionBar.findViewById(R.id.cw_action_bar_right_image);
            cwBaseActivity2.mActionBarTitle.setOnClickListener(this.listener);
            cwBaseActivity2.mActionBarLeftButton.setOnClickListener(this.listener);
            cwBaseActivity2.mActionBarRightButton.setOnClickListener(this.listener);
            cwBaseActivity2.mContainer.addView(this.mActionBar, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, UiUtil.dip2px(45.0f)));
        }
    }

    protected final void hideUiMenu() {
        ActionBar actionBar = this.getActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }
        CwBaseActivity cwBaseActivity = this;
        cwBaseActivity.getWindow().addFlags(1024);
        cwBaseActivity.getWindow().addFlags(128);
    }

    protected void setTranslucentStatus(int n) {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 21) {
            Window window = this.getWindow();
            window.clearFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(0);
            if (n2 >= 23) {
                this.getWindow().getDecorView().setSystemUiVisibility(9216);
            }
            Window window2 = window;
            window2.addFlags(Integer.MIN_VALUE);
            window2.setStatusBarColor(n);
        } else if (n2 >= 19) {
            this.getWindow().addFlags(0x4000000);
        }
    }

    public final boolean checkPermissions() {
        String[] stringArray = PERMISSIONS;
        int n = PERMISSIONS.length;
        for (int i = 0; i < n; ++i) {
            if (ActivityCompat.checkSelfPermission((Context)this, (String)stringArray[i]) != -1) continue;
            return false;
        }
        return true;
    }

    public final void requestPermissions() {
        if (this.checkPermissions()) {
            this.passPermissions();
            return;
        }
        ActivityCompat.requestPermissions((Activity)this, (String[])PERMISSIONS, (int)136);
    }

    protected final TextView getActionBarTitleView() {
        return this.mActionBarTitle;
    }

    protected final View getActionBarView() {
        return this.mActionBar;
    }

    protected ImageView getActionBarLeftView() {
        return this.mActionBarLeftButton;
    }

    protected ImageView getActionBarRightImageView() {
        return this.mActionBarRightButton;
    }

    protected void onRightClick(View view) {
    }

    protected void onLeftClick(View view) {
        this.finish();
    }

    protected final Context getContext() {
        return this;
    }

    protected final <T extends CwBaseFragment> T createFragment(String string2) {
        try {
            return (T)((Object)((CwBaseFragment)((Object)Class.forName(string2).newInstance())));
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return null;
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (n == 136) {
            this.requestPermissions();
        }
    }

    public final void onRequestPermissionsResult(int n, @NonNull String[] object, @NonNull int[] nArray) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        super.onRequestPermissionsResult(n, object, nArray);
        if (n != 136) {
            return;
        }
        ArrayList<String> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<String>(((String[])object).length + 1);
        ArrayList<String> arrayList4 = arrayList;
        arrayList = new ArrayList<String>(((String[])object).length + 1);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)object[i])) {
                arrayList3.add(object[i]);
                continue;
            }
            arrayList4.add(object[i]);
        }
        if (arrayList3.isEmpty() && arrayList4.isEmpty()) {
            this.passPermissions();
            return;
        }
        if (this.permissioDialog == null) {
            LiveTimeOutDialog liveTimeOutDialog;
            object = liveTimeOutDialog;
            liveTimeOutDialog = new LiveTimeOutDialog(this.getContext(), R.layout.cw_dialog_premission);
            this.permissioDialog = object;
        }
        this.permissioDialog.setCancelable(false);
        if (!arrayList3.isEmpty()) {
            this.permissioDialog.setOnDialogClickListener(new OnDialogClickListener(){

                public void onDialogClick(Dialog dialog, int n) {
                    if (n == R.id.cw_cancel) {
                        CwBaseActivity.this.forbidPermissions();
                    } else if (n == R.id.cw_pass) {
                        CwBaseActivity.this.requestPermissions();
                    }
                    CwBaseActivity.this.permissioDialog.dismiss();
                }
            });
        } else {
            this.permissioDialog.setOnDialogClickListener(new OnDialogClickListener(){

                public void onDialogClick(Dialog dialog, int n) {
                    if (n == R.id.cw_cancel) {
                        CwBaseActivity.this.forbidPermissions();
                    } else if (n == R.id.cw_pass) {
                        Intent intent;
                        dialog = intent;
                        dialog("android.settings.APPLICATION_DETAILS_SETTINGS");
                        intent.setData(Uri.fromParts((String)"package", (String)CwBaseActivity.this.getPackageName(), null));
                        CwBaseActivity.this.startActivityForResult((Intent)dialog, 136);
                    }
                    CwBaseActivity.this.permissioDialog.dismiss();
                }
            });
        }
        this.permissioDialog.show(1);
    }

    protected final Context updateLanguage(Context context, Locale locale) {
        Configuration configuration;
        Locale.setDefault(locale);
        CwBaseActivity cwBaseActivity = context.getResources();
        Configuration configuration2 = configuration;
        configuration = new Configuration(cwBaseActivity.getConfiguration());
        if (Build.VERSION.SDK_INT >= 17) {
            configuration2.setLocale(locale);
            context = context.createConfigurationContext(configuration2);
        } else {
            CwBaseActivity cwBaseActivity2 = cwBaseActivity;
            configuration2.locale = locale;
            cwBaseActivity2.updateConfiguration(configuration2, cwBaseActivity2.getDisplayMetrics());
        }
        return context;
    }

    protected void passPermissions() {
    }

    protected void forbidPermissions() {
    }
}

