/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.sms;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import com.truebanana.sms.SMSStatusListener;
import java.util.ArrayList;
import java.util.WeakHashMap;

public class SMSUtils {
    private static int requestCode = 10000;
    private static WeakHashMap<Integer, SMSStatusListener> listeners = new WeakHashMap();
    private static BroadcastReceiver sentReceiver = new BroadcastReceiver(){

        public void onReceive(Context c, Intent intent) {
            int requestCode = intent.getIntExtra("requestCode", 0);
            if (requestCode > 0) {
                int resultCode = this.getResultCode();
                SMSStatusListener listener = (SMSStatusListener)listeners.get(requestCode);
                if (listener != null) {
                    switch (resultCode) {
                        case -1: {
                            listener.onSMSSent();
                            break;
                        }
                        default: {
                            listener.onSMSSendingFailed(resultCode);
                        }
                    }
                    listeners.remove(requestCode);
                }
            }
        }
    };
    private static BroadcastReceiver deliveredReceiver = new BroadcastReceiver(){

        public void onReceive(Context c, Intent intent) {
            int requestCode = intent.getIntExtra("requestCode", 0);
            if (requestCode > 0) {
                int resultCode = this.getResultCode();
                SMSStatusListener listener = (SMSStatusListener)listeners.get(requestCode);
                if (listener != null) {
                    switch (resultCode) {
                        case -1: {
                            listener.onSMSDelivered();
                            break;
                        }
                        default: {
                            listener.onSMSDeliveryFailed();
                        }
                    }
                    listeners.remove(requestCode);
                }
            }
        }
    };

    public static void onResume(Context context) {
        IntentFilter sentFilter = new IntentFilter("SMS_SENT");
        IntentFilter deliveredFilter = new IntentFilter("SMS_DELIVERED");
        context.registerReceiver(sentReceiver, sentFilter);
        context.registerReceiver(deliveredReceiver, deliveredFilter);
    }

    public static void onPause(Context context) {
        context.unregisterReceiver(sentReceiver);
        context.unregisterReceiver(deliveredReceiver);
    }

    public static void sendSMS(String phoneNumber, String message) {
        SMSUtils.sendSMS(phoneNumber, null, message);
    }

    public static void sendSMS(String phoneNumber, String sc, String message) {
        SMSUtils.sendSMS(null, phoneNumber, sc, message, null);
    }

    public static void sendSMS(Context context, String phoneNumber, String message, SMSStatusListener listener) {
        SMSUtils.sendSMS(context, phoneNumber, null, message, listener);
    }

    public static void sendSMS(Context context, String phoneNumber, String sc, String message, SMSStatusListener listener) {
        SmsManager smsManager = SmsManager.getDefault();
        PendingIntent sentIntent = null;
        PendingIntent deliveryIntent = null;
        if (context != null && listener != null) {
            String sentAction = "SMS_SENT";
            String deliveryAction = "SMS_DELIVERED";
            Intent si = new Intent("SMS_SENT");
            si.putExtra("requestCode", requestCode);
            sentIntent = PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)si, (int)0);
            listeners.put(requestCode, listener);
            Intent di = new Intent("SMS_DELIVERED");
            di.putExtra("requestCode", ++requestCode);
            deliveryIntent = PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)di, (int)0);
            listeners.put(requestCode, listener);
            ++requestCode;
        }
        if (message.length() > 160) {
            ArrayList messageParts = smsManager.divideMessage(message);
            ArrayList<PendingIntent> sentIntents = new ArrayList<PendingIntent>();
            ArrayList<PendingIntent> deliveryIntents = new ArrayList<PendingIntent>();
            sentIntents.add(sentIntent);
            deliveryIntents.add(deliveryIntent);
            smsManager.sendMultipartTextMessage(phoneNumber, sc, messageParts, sentIntents, deliveryIntents);
        } else {
            smsManager.sendTextMessage(phoneNumber, sc, message, sentIntent, deliveryIntent);
        }
    }

    public static String combineMultipartSMS(Context context, Intent intent) {
        Object[] pdus;
        Bundle bundle = intent.getExtras();
        if (bundle != null && (pdus = (Object[])bundle.get("pdus")) != null) {
            SmsMessage[] messages = new SmsMessage[pdus.length];
            for (int i = 0; i < pdus.length; ++i) {
                messages[i] = SmsMessage.createFromPdu((byte[])((byte[])pdus[i]));
            }
            StringBuilder content = new StringBuilder();
            if (messages.length > 0) {
                for (SmsMessage message : messages) {
                    content.append(message.getMessageBody());
                }
            }
            return content.toString();
        }
        return null;
    }
}

