/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.http;

import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import com.truebanana.async.Async;
import com.truebanana.http.BasicResponseListener;
import com.truebanana.http.HTTPRequestBodyProvider;
import com.truebanana.http.HTTPRequestError;
import com.truebanana.http.HTTPRequestMethod;
import com.truebanana.http.HTTPResponse;
import com.truebanana.http.HTTPResponseListener;
import com.truebanana.http.MockResponse;
import com.truebanana.http.MultiPartContent;
import com.truebanana.log.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.json.JSONObject;

public class HTTPRequest {
    private HTTPResponseListener responseListener = defaultResponseListener;
    private HTTPRequestMethod requestMethod = HTTPRequestMethod.GET;
    private String url;
    private String body;
    private MultiPartContent multiPartContent;
    private String logTag;
    private boolean verifySSL = true;
    private int readTimeout = defaultReadTimeout;
    private int connectTimeout = defaultConnectTimeout;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> queryParameters = new HashMap<String, String>();
    private HTTPRequestBodyProvider bodyProvider;
    private InputStream keyStore;
    private InputStream trustStore;
    private String keyStorePassword;
    private String trustStorePassword;
    private MockResponse mockResponse;
    private static int defaultReadTimeout = 10000;
    private static int defaultConnectTimeout = 10000;
    private static HTTPResponseListener defaultResponseListener = new BasicResponseListener(){};
    private static Deque<HTTPRequest> requestQueue = new LinkedBlockingDeque<HTTPRequest>();
    private static HTTPRequest pendingRequest = null;
    Handler handler = new Handler();

    private HTTPRequest() {
    }

    public static HTTPRequest create(String url) {
        HTTPRequest request = new HTTPRequest();
        request.url = url;
        try {
            URL uRL = new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Invalid URL.");
        }
        return request;
    }

    private HttpURLConnection buildURLConnection() {
        try {
            String port;
            String host;
            Uri.Builder builder = Uri.parse((String)this.url).buildUpon();
            for (Map.Entry<String, String> pair : this.queryParameters.entrySet()) {
                builder.appendQueryParameter(pair.getKey(), pair.getValue());
            }
            URL u = new URL(builder.build().toString());
            Proxy proxy = Proxy.NO_PROXY;
            if (Build.VERSION.SDK_INT > 12 && (host = System.getProperty("http.proxyHost")) != null && !host.isEmpty() && (port = System.getProperty("http.proxyPort")) != null && !port.isEmpty()) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, Integer.parseInt(port)));
            }
            HttpURLConnection urlConnection = (HttpURLConnection)u.openConnection(proxy);
            urlConnection.setRequestMethod(this.requestMethod.name());
            urlConnection.setDoInput(true);
            urlConnection.setConnectTimeout(this.connectTimeout);
            urlConnection.setReadTimeout(this.readTimeout);
            switch (this.requestMethod) {
                case POST: 
                case PUT: {
                    urlConnection.setDoOutput(true);
                    break;
                }
                default: {
                    urlConnection.setDoOutput(false);
                }
            }
            return urlConnection;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Invalid URL.");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Invalid URL.");
        }
    }

    public HTTPRequest clone() {
        HTTPRequest r = HTTPRequest.create(this.url);
        r.setRequestMethod(this.requestMethod);
        r.setReadTimeout(this.readTimeout);
        r.setConnectTimeout(this.connectTimeout);
        r.addHeaders(this.headers);
        r.addQueryParameters(this.queryParameters);
        r.setRequestBody(this.body);
        r.setRequestBodyProvider(this.bodyProvider);
        r.setTrustStore(this.trustStore, this.trustStorePassword);
        r.setKeyStore(this.keyStore, this.keyStorePassword);
        r.setHTTPResponseListener(this.responseListener);
        r.setSSLVerificationEnabled(this.verifySSL);
        r.setLogTag(this.logTag);
        return r;
    }

    public HTTPRequest setRequestMethod(HTTPRequestMethod requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public HTTPRequest setGet() {
        this.setRequestMethod(HTTPRequestMethod.GET);
        return this;
    }

    public HTTPRequest setPost() {
        this.setRequestMethod(HTTPRequestMethod.POST);
        return this;
    }

    public HTTPRequest setPut() {
        this.setRequestMethod(HTTPRequestMethod.PUT);
        return this;
    }

    public HTTPRequest setDelete() {
        this.setRequestMethod(HTTPRequestMethod.DELETE);
        return this;
    }

    public HTTPRequest setReadTimeout(int millis) {
        this.readTimeout = millis;
        return this;
    }

    public HTTPRequest setConnectTimeout(int millis) {
        this.connectTimeout = millis;
        return this;
    }

    public HTTPRequest addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public HTTPRequest addHeaders(Map<String, String> headers) {
        Set<Map.Entry<String, String>> entries = headers.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HTTPRequest addQueryParameter(String key, String value) {
        this.queryParameters.put(key, value);
        return this;
    }

    public HTTPRequest addQueryParameters(Map<String, String> headers) {
        Set<Map.Entry<String, String>> entries = headers.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            this.addQueryParameter(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HTTPRequest setHeaderValue(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public HTTPRequest setRequestBody(String body) {
        this.body = body;
        return this;
    }

    public HTTPRequest setRequestBody(JSONObject body) {
        return this.setRequestBody(body.toString());
    }

    public HTTPRequest setRequestBody(MultiPartContent body) {
        this.multiPartContent = body;
        this.setHeaderValue("Content-Type", "multipart/form-data;boundary=" + body.getBoundary());
        return this;
    }

    public HTTPRequest setRequestBodyProvider(HTTPRequestBodyProvider provider) {
        this.bodyProvider = provider;
        return this;
    }

    public HTTPRequest setTrustStore(InputStream trustStore, String password) {
        this.trustStore = trustStore;
        this.trustStorePassword = password;
        return this;
    }

    public HTTPRequest setKeyStore(InputStream keyStore, String password) {
        this.keyStore = keyStore;
        this.keyStorePassword = password;
        return this;
    }

    public HTTPRequest setHTTPResponseListener(HTTPResponseListener listener) {
        this.responseListener = listener;
        return this;
    }

    public HTTPRequest setSSLVerificationEnabled(boolean enabled) {
        this.verifySSL = enabled;
        return this;
    }

    public HTTPRequest setMockResponse(MockResponse mockResponse) {
        this.mockResponse = mockResponse;
        return this;
    }

    public HTTPRequest setLogTag(String tag) {
        this.logTag = tag;
        return this;
    }

    public String getRequestBody() {
        return this.body;
    }

    public MultiPartContent getMultiPartContentRequestBody() {
        return this.multiPartContent;
    }

    private void onPreExecute() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                HTTPRequest.this.responseListener.onPreExecute();
            }
        });
    }

    private void onPostExecute() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                HTTPRequest.this.responseListener.onPostExecute();
            }
        });
    }

    private void onRequestCompleted(final HTTPResponse response) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                HTTPRequest.this.responseListener.onRequestCompleted(response);
            }
        });
    }

    private void onRequestError(final HTTPRequestError error) {
        this.log("Request Error", error.name());
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                HTTPRequest.this.responseListener.onRequestError(error);
            }
        });
    }

    private void onRequestTerminated() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (pendingRequest == HTTPRequest.this) {
                    pendingRequest = null;
                    HTTPRequest.this.executeFromQueueIfFree();
                }
            }
        });
    }

    public HTTPRequest executeAsync() {
        Async.executeAsync(new Runnable(){

            @Override
            public void run() {
                HttpURLConnection urlConnection = HTTPRequest.this.buildURLConnection();
                if (HTTPRequest.this.bodyProvider != null) {
                    HTTPRequest.this.body = HTTPRequest.this.bodyProvider.getRequestBody();
                }
                if (urlConnection instanceof HttpsURLConnection) {
                    HttpsURLConnection httpsURLConnection = (HttpsURLConnection)urlConnection;
                    try {
                        httpsURLConnection.setSSLSocketFactory(new FlexibleSSLSocketFactory(HTTPRequest.this.trustStore, HTTPRequest.this.trustStorePassword, HTTPRequest.this.keyStore, HTTPRequest.this.keyStorePassword, !HTTPRequest.this.verifySSL));
                    }
                    catch (GeneralSecurityException e) {
                        e.printStackTrace();
                        HTTPRequest.this.onRequestError(HTTPRequestError.SECURITY_EXCEPTION);
                        HTTPRequest.this.onRequestTerminated();
                        return;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        HTTPRequest.this.onRequestError(HTTPRequestError.KEYSTORE_INVALID);
                        HTTPRequest.this.onRequestTerminated();
                        return;
                    }
                    if (!HTTPRequest.this.verifySSL) {
                        httpsURLConnection.setHostnameVerifier(new NoVerifyHostnameVerifier());
                        HTTPRequest.this.log("SSL Verification Disabled", "**********");
                    }
                }
                HTTPRequest.this.log("Endpoint", urlConnection.getURL().toString());
                for (Map.Entry pair : HTTPRequest.this.headers.entrySet()) {
                    urlConnection.addRequestProperty((String)pair.getKey(), (String)pair.getValue());
                    HTTPRequest.this.log("Request Header", (String)pair.getKey() + ": " + (String)pair.getValue());
                }
                if (HTTPRequest.this.multiPartContent != null) {
                    HTTPRequest.this.log("Multipart Request Boundary", HTTPRequest.this.multiPartContent.getBoundary());
                    int counter = 1;
                    for (MultiPartContent.Part part : HTTPRequest.this.multiPartContent.getParts()) {
                        HTTPRequest.this.log("Request Body Part " + counter, "Name: " + part.getName() + "; File Name: " + part.getFileName());
                        for (Map.Entry<String, String> pair : part.getHeaders().entrySet()) {
                            HTTPRequest.this.log("Request Body Part " + counter + " Header", pair.getKey() + ": " + pair.getValue());
                        }
                    }
                } else {
                    HTTPRequest.this.log("Request Body", HTTPRequest.this.body);
                }
                if (HTTPRequest.this.mockResponse == null) {
                    InputStream content;
                    HTTPRequest.this.onPreExecute();
                    try {
                        if (HTTPRequest.this.multiPartContent != null) {
                            HTTPRequest.this.multiPartContent.write(urlConnection.getOutputStream());
                        } else if (HTTPRequest.this.body != null) {
                            OutputStream os = urlConnection.getOutputStream();
                            OutputStreamWriter writer = new OutputStreamWriter(os);
                            writer.write(HTTPRequest.this.body);
                            writer.flush();
                            writer.close();
                            os.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        HTTPRequest.this.onRequestError(HTTPRequestError.OTHER);
                        HTTPRequest.this.onRequestTerminated();
                        return;
                    }
                    try {
                        content = urlConnection.getInputStream();
                        HTTPRequest.this.onPostExecute();
                    }
                    catch (SocketTimeoutException e) {
                        e.printStackTrace();
                        HTTPRequest.this.onPostExecute();
                        HTTPRequest.this.onRequestError(HTTPRequestError.TIMEOUT);
                        HTTPRequest.this.onRequestTerminated();
                        return;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        content = urlConnection.getErrorStream();
                        HTTPRequest.this.onPostExecute();
                    }
                    HTTPResponse response = HTTPResponse.from(HTTPRequest.this, urlConnection, content);
                    if (response.isConnectionError()) {
                        HTTPRequest.this.onRequestError(HTTPRequestError.OTHER);
                        HTTPRequest.this.onRequestTerminated();
                        return;
                    }
                    HTTPRequest.this.log("Response Message", response.getResponseMessage());
                    HTTPRequest.this.log("Response Content", response.getStringContent());
                    HTTPRequest.this.onRequestCompleted(response);
                    urlConnection.disconnect();
                    HTTPRequest.this.onRequestTerminated();
                } else {
                    HTTPRequest.this.onPreExecute();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    HTTPRequest.this.onPostExecute();
                    HTTPRequest.this.log("Response Message", HTTPRequest.this.mockResponse.getResponseMessage());
                    HTTPRequest.this.log("Response Content", HTTPRequest.this.mockResponse.getStringContent());
                    HTTPRequest.this.onRequestCompleted(HTTPRequest.this.mockResponse);
                    urlConnection.disconnect();
                    HTTPRequest.this.onRequestTerminated();
                }
            }
        });
        return this;
    }

    public HTTPRequest queue() {
        requestQueue.add(this);
        this.executeFromQueueIfFree();
        return this;
    }

    public HTTPRequest queueFirst() {
        requestQueue.addFirst(this);
        this.executeFromQueueIfFree();
        return this;
    }

    public HTTPRequest dequeue() {
        requestQueue.remove(this);
        return this;
    }

    private void executeFromQueueIfFree() {
        if (pendingRequest == null && !requestQueue.isEmpty()) {
            pendingRequest = requestQueue.remove();
            pendingRequest.executeAsync();
        }
    }

    public static Queue<HTTPRequest> getRequestQueue() {
        return requestQueue;
    }

    public static void clearRequestQueue() {
        requestQueue.clear();
    }

    private void log(String baseTag, String message) {
        if (this.logTag != null) {
            Log.d(this.logTag + " " + baseTag, message);
        }
    }

    private class FlexibleSSLSocketFactory
    extends SSLSocketFactory {
        SSLContext sslContext = SSLContext.getInstance("TLS");

        public FlexibleSSLSocketFactory(boolean trustAll) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, IOException {
            this(null, null, null, null, trustAll);
        }

        public FlexibleSSLSocketFactory(InputStream keyStoreStream, String keyStorePassword, boolean trustAll) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, IOException {
            this(null, null, keyStoreStream, keyStorePassword, trustAll);
        }

        public FlexibleSSLSocketFactory(InputStream trustStoreStream, String trustStorePassword) throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, IOException {
            this(trustStoreStream, trustStorePassword, null, null, false);
        }

        public FlexibleSSLSocketFactory(InputStream trustStoreStream, String trustStorePassword, InputStream keyStoreStream, String keyStorePassword, boolean trustAll) throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException {
            TrustManager[] trustManagers = null;
            KeyManager[] keyManagers = null;
            if (trustAll) {
                trustManagers = new TrustManager[]{new NoVerifyTrustManager()};
            } else if (trustStoreStream != null) {
                KeyStore trustStore = KeyStore.getInstance("BKS");
                trustStore.load(trustStoreStream, trustStorePassword.toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(trustStore);
                trustManagers = tmf.getTrustManagers();
            }
            if (keyStoreStream != null) {
                KeyStore ks = KeyStore.getInstance("PKCS12");
                ks.load(keyStoreStream, keyStorePassword.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, keyStorePassword.toCharArray());
                keyManagers = kmf.getKeyManagers();
            }
            this.sslContext.init(keyManagers, trustManagers, null);
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.sslContext.getSocketFactory().getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.sslContext.getSocketFactory().getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
            return this.processSocket((SSLSocket)this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose));
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.processSocket((SSLSocket)this.sslContext.getSocketFactory().createSocket());
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.processSocket((SSLSocket)this.sslContext.getSocketFactory().createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.processSocket((SSLSocket)this.sslContext.getSocketFactory().createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.processSocket((SSLSocket)this.sslContext.getSocketFactory().createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.processSocket((SSLSocket)this.sslContext.getSocketFactory().createSocket(address, port, localAddress, localPort));
        }

        private SSLSocket processSocket(SSLSocket socket) {
            ArrayList<String> cipherSuites = new ArrayList<String>(Arrays.asList(socket.getEnabledCipherSuites()));
            cipherSuites.add("SSL_RSA_WITH_3DES_EDE_CBC_SHA");
            String[] modifiedSuites = new String[cipherSuites.size()];
            socket.setEnabledCipherSuites(cipherSuites.toArray(modifiedSuites));
            return socket;
        }
    }

    private static class NoVerifyHostnameVerifier
    implements HostnameVerifier {
        private NoVerifyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class NoVerifyTrustManager
    implements X509TrustManager {
        private NoVerifyTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }
    }
}

