/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.data;

import com.truebanana.crypto.Crypto;
import com.truebanana.json.JSONUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class SecureData {
    protected JSONObject data;
    protected String password;

    public SecureData(byte[] data, String password) {
        this.password = password;
        this.load(data);
    }

    public SecureData(InputStream inputStream, String password) {
        this.password = password;
        try {
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            this.load(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load(byte[] data) {
        if (data != null && data.length > 0) {
            byte[] decryptedData = Crypto.decrypt(data, this.password, Spec.getInstance());
            if (decryptedData != null) {
                this.load(new String(decryptedData));
            } else {
                this.load(new JSONObject());
            }
        } else {
            this.load(new JSONObject());
        }
    }

    public void load(String jsonString) {
        this.load(JSONUtils.toJSONObject(jsonString));
    }

    public void load(JSONObject json) {
        this.data = json != null ? json : new JSONObject();
    }

    public boolean equals(SecureData secureData) {
        try {
            return JSONCompare.compareJSON((String)this.toString(false), (String)secureData.toString(false), (JSONCompareMode)JSONCompareMode.LENIENT).passed();
        }
        catch (JSONException e) {
            return false;
        }
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean encrypted) {
        String stringData = this.data.toString();
        if (encrypted) {
            stringData = new String(Crypto.encrypt(stringData.getBytes(), this.password, Spec.getInstance()));
        }
        return stringData;
    }

    public byte[] toByteArray() {
        return this.toByteArray(true);
    }

    public byte[] toByteArray(boolean encrypted) {
        byte[] bytes = this.data.toString().getBytes();
        if (encrypted) {
            return Crypto.encrypt(bytes, this.password, Spec.getInstance());
        }
        return bytes;
    }

    public String getString(String key, String defaultValue) {
        try {
            return this.data.getString(key);
        }
        catch (JSONException e) {
            this.put(key, defaultValue);
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(this.data.getString(key));
        }
        catch (JSONException e) {
            this.put(key, defaultValue);
            return defaultValue;
        }
    }

    public int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.data.getString(key));
        }
        catch (JSONException e) {
            this.put(key, defaultValue);
        }
        catch (NumberFormatException e) {
            this.put(key, defaultValue);
        }
        return defaultValue;
    }

    public long getLong(String key, long defaultValue) {
        try {
            return Long.parseLong(this.data.getString(key));
        }
        catch (JSONException e) {
            this.put(key, defaultValue);
        }
        catch (NumberFormatException e) {
            this.put(key, defaultValue);
        }
        return defaultValue;
    }

    public float getFloat(String key, float defaultValue) {
        try {
            return Float.parseFloat(this.data.getString(key));
        }
        catch (JSONException e) {
            this.put(key, defaultValue);
        }
        catch (NumberFormatException e) {
            this.put(key, defaultValue);
        }
        return defaultValue;
    }

    public double getDouble(String key, double defaultValue) {
        try {
            return Double.parseDouble(this.data.getString(key));
        }
        catch (JSONException e) {
            this.put(key, defaultValue);
        }
        catch (NumberFormatException e) {
            this.put(key, defaultValue);
        }
        return defaultValue;
    }

    public JSONObject getJSONObject(String key) {
        try {
            return this.data.getJSONObject(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public JSONArray getJSONArray(String key) {
        try {
            return this.data.getJSONArray(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public SecureData put(String key, String value) {
        try {
            this.data.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid value");
        }
        return this;
    }

    public SecureData put(String key, boolean value) {
        try {
            this.data.put(key, (Object)String.valueOf(value));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid value");
        }
        return this;
    }

    public SecureData put(String key, int value) {
        try {
            this.data.put(key, (Object)String.valueOf(value));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid value");
        }
        return this;
    }

    public SecureData put(String key, long value) {
        try {
            this.data.put(key, (Object)String.valueOf(value));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid value");
        }
        return this;
    }

    public SecureData put(String key, float value) {
        try {
            this.data.put(key, (Object)String.valueOf(value));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid value");
        }
        return this;
    }

    public SecureData put(String key, double value) {
        try {
            this.data.put(key, (Object)String.valueOf(value));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid value");
        }
        return this;
    }

    public SecureData put(String key, JSONObject json) {
        try {
            this.data.put(key, (Object)json);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid value");
        }
        return this;
    }

    public SecureData put(String key, JSONArray json) {
        try {
            this.data.put(key, (Object)json);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid value");
        }
        return this;
    }

    public SecureData remove(String key) {
        this.data.remove(key);
        return this;
    }

    public boolean isEmpty() {
        return this.data.length() == 0;
    }

    public static class Spec
    extends Crypto.Spec {
        private static final Spec INSTANCE = new Spec();

        private Spec() {
            this.setKeyDerivationIterations(128);
        }

        public static Spec getInstance() {
            return INSTANCE;
        }
    }
}

