/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.async;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import com.truebanana.async.BackgroundTask;
import java.util.concurrent.Executor;

public class Async {
    private static Handler mainHandler = new Handler(Looper.getMainLooper());
    private static Executor parallelExecutor = AsyncTask.THREAD_POOL_EXECUTOR;
    private static Executor serialExecutor = AsyncTask.SERIAL_EXECUTOR;

    public static void executeAsync(final BackgroundTask task, boolean executeInParallel) {
        AsyncTask<Void, Void, Object> asyncTask = new AsyncTask<Void, Void, Object>(){

            protected Object doInBackground(Void ... params) {
                return task.doInBackground();
            }

            protected void onPostExecute(Object result) {
                task.onPostExecute(result);
            }
        };
        asyncTask.executeOnExecutor(executeInParallel ? parallelExecutor : serialExecutor, (Object[])new Void[0]);
    }

    public static void executeAsync(BackgroundTask task) {
        Async.executeAsync(task, true);
    }

    public static void executeAsync(Runnable runnable, boolean executeInParallel) {
        if (executeInParallel) {
            parallelExecutor.execute(runnable);
        } else {
            serialExecutor.execute(runnable);
        }
    }

    public static void executeAsync(Runnable runnable) {
        Async.executeAsync(runnable, true);
    }

    public static void executeInMainThread(Runnable runnable) {
        mainHandler.post(runnable);
    }

    public static void executeInMainThread(Runnable runnable, long delayMillis) {
        mainHandler.postDelayed(runnable, delayMillis);
    }
}

