/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.data;

import android.content.Context;
import com.truebanana.async.Async;
import com.truebanana.data.SecureData;
import com.truebanana.log.Log;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class SecureDataFile
extends SecureData {
    private File file;
    private static Map<String, SecureDataFile> loadedDataFiles = new HashMap<String, SecureDataFile>();

    private SecureDataFile(byte[] data, File file, String password) {
        super(data, password);
        this.file = file;
    }

    public static SecureDataFile getDefault(Context context, String password) {
        return SecureDataFile.getDataFile(context, "data", password);
    }

    public static SecureDataFile getDataFile(Context context, String fileName, String password) {
        return SecureDataFile.loadFromFile(new File(context.getFilesDir().getPath(), fileName), password);
    }

    public static SecureDataFile loadFromFile(File file, String password) {
        String filePath = file.getAbsolutePath();
        if (loadedDataFiles.containsKey(filePath)) {
            Log.d("SecureDataFile", "Loading cached data file");
            return loadedDataFiles.get(filePath);
        }
        Log.d("SecureDataFile", "Loading data file from disk");
        byte[] data = new byte[]{};
        try {
            data = FileUtils.readFileToByteArray((File)file);
            Log.d("SecureDataFile", "Successfully read data file");
        }
        catch (IOException e) {
            Log.d("SecureDataFile", "Could not read data file");
        }
        SecureDataFile dataFile = new SecureDataFile(data, file, password);
        loadedDataFiles.put(filePath, dataFile);
        return dataFile;
    }

    public void saveAsync() {
        Async.executeAsync(new Runnable(){

            @Override
            public void run() {
                SecureDataFile.this.save();
            }
        });
    }

    public synchronized void save() {
        try {
            FileUtils.writeByteArrayToFile((File)this.file, (byte[])this.toByteArray());
            Log.d("SecureDataFile", "Successfully written data file");
        }
        catch (IOException e) {
            Log.d("SecureDataFile", "Could not write data file");
        }
    }
}

