/*
 * Decompiled with CFR 0.152.
 */
package com.truebanana.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.truebanana.cache.AbstractDiskLruCache;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;

public class BitmapDiskCache
extends AbstractDiskLruCache<Bitmap> {
    public BitmapDiskCache(Context context) {
        super(context);
    }

    public BitmapDiskCache(Context context, long maxSize) {
        super(context, maxSize);
    }

    public BitmapDiskCache(File directory) {
        super(directory);
    }

    public BitmapDiskCache(File directory, long maxSize) {
        super(directory, maxSize);
    }

    @Override
    public Bitmap get(String key) {
        byte[] data = this.getData(key);
        return BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
    }

    @Override
    public void put(String key, Bitmap item) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        item.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
        this.putData(key, os.toByteArray());
    }
}

