/*
 * Decompiled with CFR 0.152.
 */
package com.trello.lifecycle4.android.lifecycle;

import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import com.trello.rxlifecycle4.LifecycleTransformer;
import com.trello.rxlifecycle4.OutsideLifecycleException;
import com.trello.rxlifecycle4.RxLifecycle;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.functions.Function;

public final class RxLifecycleAndroidLifecycle {
    private static final Function<Lifecycle.Event, Lifecycle.Event> LIFECYCLE = new Function<Lifecycle.Event, Lifecycle.Event>(){

        public Lifecycle.Event apply(Lifecycle.Event lastEvent) throws Exception {
            switch (lastEvent) {
                case ON_CREATE: {
                    return Lifecycle.Event.ON_DESTROY;
                }
                case ON_START: {
                    return Lifecycle.Event.ON_STOP;
                }
                case ON_RESUME: {
                    return Lifecycle.Event.ON_PAUSE;
                }
                case ON_PAUSE: {
                    return Lifecycle.Event.ON_STOP;
                }
                case ON_STOP: {
                    return Lifecycle.Event.ON_DESTROY;
                }
                case ON_DESTROY: {
                    throw new OutsideLifecycleException("Cannot bind to Activity lifecycle when outside of it.");
                }
            }
            throw new UnsupportedOperationException("Binding to " + lastEvent + " not yet implemented");
        }
    };

    private RxLifecycleAndroidLifecycle() {
        throw new AssertionError((Object)"No instances");
    }

    @NonNull
    @CheckResult
    public static <T> LifecycleTransformer<T> bindLifecycle(@NonNull Observable<Lifecycle.Event> lifecycle) {
        return RxLifecycle.bind(lifecycle, LIFECYCLE);
    }
}

