/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.jayway.jsonpath.spi.mapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.Callable;
import shaded.com.jayway.jsonpath.Configuration;
import shaded.com.jayway.jsonpath.TypeRef;
import shaded.com.jayway.jsonpath.spi.mapper.MappingException;
import shaded.com.jayway.jsonpath.spi.mapper.MappingProvider;
import shaded.net.minidev.json.JSONValue;
import shaded.net.minidev.json.writer.JsonReader;
import shaded.net.minidev.json.writer.JsonReaderI;

public class JsonSmartMappingProvider
implements MappingProvider {
    private static JsonReader DEFAULT = new JsonReader();
    private final Callable<JsonReader> factory;

    public JsonSmartMappingProvider(final JsonReader jsonReader) {
        this(new Callable<JsonReader>(){

            @Override
            public JsonReader call() {
                return jsonReader;
            }
        });
    }

    public JsonSmartMappingProvider(Callable<JsonReader> factory) {
        this.factory = factory;
    }

    public JsonSmartMappingProvider() {
        this(DEFAULT);
    }

    @Override
    public <T> T map(Object source, Class<T> targetType, Configuration configuration) {
        if (source == null) {
            return null;
        }
        if (targetType.isAssignableFrom(source.getClass())) {
            return (T)source;
        }
        try {
            if (!configuration.jsonProvider().isMap(source) && !configuration.jsonProvider().isArray(source)) {
                return this.factory.call().getMapper(targetType).convert(source);
            }
            String s = configuration.jsonProvider().toJson(source);
            return (T)JSONValue.parse(s, targetType);
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }

    @Override
    public <T> T map(Object source, TypeRef<T> targetType, Configuration configuration) {
        throw new UnsupportedOperationException("Json-smart provider does not support TypeRef! Use a Jackson or Gson based provider");
    }

    static {
        DEFAULT.registerReader(Long.class, new LongReader());
        DEFAULT.registerReader(Long.TYPE, new LongReader());
        DEFAULT.registerReader(Integer.class, new IntegerReader());
        DEFAULT.registerReader(Integer.TYPE, new IntegerReader());
        DEFAULT.registerReader(Double.class, new DoubleReader());
        DEFAULT.registerReader(Double.TYPE, new DoubleReader());
        DEFAULT.registerReader(Float.class, new FloatReader());
        DEFAULT.registerReader(Float.TYPE, new FloatReader());
        DEFAULT.registerReader(BigDecimal.class, new BigDecimalReader());
        DEFAULT.registerReader(String.class, new StringReader());
        DEFAULT.registerReader(Date.class, new DateReader());
        DEFAULT.registerReader(BigInteger.class, new BigIntegerReader());
        DEFAULT.registerReader(Boolean.TYPE, new BooleanReader());
    }

    private static class BooleanReader
    extends JsonReaderI<Boolean> {
        public BooleanReader() {
            super(null);
        }

        @Override
        public Boolean convert(Object src) {
            if (src == null) {
                return null;
            }
            if (Boolean.class.isAssignableFrom(src.getClass())) {
                return (Boolean)src;
            }
            throw new MappingException("can not map a " + src.getClass() + " to " + Boolean.class.getName());
        }
    }

    private static class DateReader
    extends JsonReaderI<Date> {
        public DateReader() {
            super(null);
        }

        @Override
        public Date convert(Object src) {
            if (src == null) {
                return null;
            }
            if (Date.class.isAssignableFrom(src.getClass())) {
                return (Date)src;
            }
            if (Long.class.isAssignableFrom(src.getClass())) {
                return new Date((Long)src);
            }
            if (String.class.isAssignableFrom(src.getClass())) {
                try {
                    return DateFormat.getInstance().parse(src.toString());
                }
                catch (ParseException e) {
                    throw new MappingException(e);
                }
            }
            throw new MappingException("can not map a " + src.getClass() + " to " + Date.class.getName());
        }
    }

    private static class BigIntegerReader
    extends JsonReaderI<BigInteger> {
        public BigIntegerReader() {
            super(null);
        }

        @Override
        public BigInteger convert(Object src) {
            if (src == null) {
                return null;
            }
            return new BigInteger(src.toString());
        }
    }

    private static class BigDecimalReader
    extends JsonReaderI<BigDecimal> {
        public BigDecimalReader() {
            super(null);
        }

        @Override
        public BigDecimal convert(Object src) {
            if (src == null) {
                return null;
            }
            return new BigDecimal(src.toString());
        }
    }

    private static class FloatReader
    extends JsonReaderI<Float> {
        public FloatReader() {
            super(null);
        }

        @Override
        public Float convert(Object src) {
            if (src == null) {
                return null;
            }
            if (Float.class.isAssignableFrom(src.getClass())) {
                return (Float)src;
            }
            if (Integer.class.isAssignableFrom(src.getClass())) {
                return Float.valueOf(((Integer)src).floatValue());
            }
            if (Long.class.isAssignableFrom(src.getClass())) {
                return Float.valueOf(((Long)src).floatValue());
            }
            if (BigDecimal.class.isAssignableFrom(src.getClass())) {
                return Float.valueOf(((BigDecimal)src).floatValue());
            }
            if (Double.class.isAssignableFrom(src.getClass())) {
                return Float.valueOf(((Double)src).floatValue());
            }
            if (String.class.isAssignableFrom(src.getClass())) {
                return Float.valueOf(src.toString());
            }
            throw new MappingException("can not map a " + src.getClass() + " to " + Float.class.getName());
        }
    }

    private static class DoubleReader
    extends JsonReaderI<Double> {
        public DoubleReader() {
            super(null);
        }

        @Override
        public Double convert(Object src) {
            if (src == null) {
                return null;
            }
            if (Double.class.isAssignableFrom(src.getClass())) {
                return (Double)src;
            }
            if (Integer.class.isAssignableFrom(src.getClass())) {
                return ((Integer)src).doubleValue();
            }
            if (Long.class.isAssignableFrom(src.getClass())) {
                return ((Long)src).doubleValue();
            }
            if (BigDecimal.class.isAssignableFrom(src.getClass())) {
                return ((BigDecimal)src).doubleValue();
            }
            if (Float.class.isAssignableFrom(src.getClass())) {
                return ((Float)src).doubleValue();
            }
            if (String.class.isAssignableFrom(src.getClass())) {
                return Double.valueOf(src.toString());
            }
            throw new MappingException("can not map a " + src.getClass() + " to " + Double.class.getName());
        }
    }

    private static class LongReader
    extends JsonReaderI<Long> {
        public LongReader() {
            super(null);
        }

        @Override
        public Long convert(Object src) {
            if (src == null) {
                return null;
            }
            if (Long.class.isAssignableFrom(src.getClass())) {
                return (Long)src;
            }
            if (Integer.class.isAssignableFrom(src.getClass())) {
                return ((Integer)src).longValue();
            }
            if (Double.class.isAssignableFrom(src.getClass())) {
                return ((Double)src).longValue();
            }
            if (BigDecimal.class.isAssignableFrom(src.getClass())) {
                return ((BigDecimal)src).longValue();
            }
            if (Float.class.isAssignableFrom(src.getClass())) {
                return ((Float)src).longValue();
            }
            if (String.class.isAssignableFrom(src.getClass())) {
                return Long.valueOf(src.toString());
            }
            throw new MappingException("can not map a " + src.getClass() + " to " + Long.class.getName());
        }
    }

    private static class IntegerReader
    extends JsonReaderI<Integer> {
        public IntegerReader() {
            super(null);
        }

        @Override
        public Integer convert(Object src) {
            if (src == null) {
                return null;
            }
            if (Integer.class.isAssignableFrom(src.getClass())) {
                return (Integer)src;
            }
            if (Long.class.isAssignableFrom(src.getClass())) {
                return ((Long)src).intValue();
            }
            if (Double.class.isAssignableFrom(src.getClass())) {
                return ((Double)src).intValue();
            }
            if (BigDecimal.class.isAssignableFrom(src.getClass())) {
                return ((BigDecimal)src).intValue();
            }
            if (Float.class.isAssignableFrom(src.getClass())) {
                return ((Float)src).intValue();
            }
            if (String.class.isAssignableFrom(src.getClass())) {
                return Integer.valueOf(src.toString());
            }
            throw new MappingException("can not map a " + src.getClass() + " to " + Integer.class.getName());
        }
    }

    private static class StringReader
    extends JsonReaderI<String> {
        public StringReader() {
            super(null);
        }

        @Override
        public String convert(Object src) {
            if (src == null) {
                return null;
            }
            return src.toString();
        }
    }
}

