/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider;

import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderFilter;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import com.tngtech.java.junit.dataprovider.internal.DataConverter;
import com.tngtech.java.junit.dataprovider.internal.TestGenerator;
import com.tngtech.java.junit.dataprovider.internal.TestValidator;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataProviderRunner
extends BlockJUnit4ClassRunner {
    DataConverter dataConverter;
    TestValidator testValidator;
    TestGenerator testGenerator;
    List<FrameworkMethod> computedTestMethods;

    public DataProviderRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        this.dataConverter = new DataConverter();
        this.testValidator = new TestValidator(this.dataConverter);
        this.testGenerator = new TestGenerator(this.dataConverter);
        super.collectInitializationErrors(errors);
    }

    protected void validateTestMethods(List<Throwable> errors) {
        if (errors == null) {
            throw new NullPointerException("errors must not be null");
        }
        for (FrameworkMethod testMethod : this.getTestClassInt().getAnnotatedMethods(Test.class)) {
            this.testValidator.validateTestMethod(testMethod, errors);
        }
        for (FrameworkMethod testMethod : this.getTestClassInt().getAnnotatedMethods(UseDataProvider.class)) {
            FrameworkMethod dataProviderMethod = this.getDataProviderMethod(testMethod);
            if (dataProviderMethod == null) {
                errors.add(new Exception("No such data provider: " + ((UseDataProvider)testMethod.getAnnotation(UseDataProvider.class)).value()));
                continue;
            }
            DataProvider dataProvider = (DataProvider)dataProviderMethod.getAnnotation(DataProvider.class);
            if (dataProvider == null) {
                throw new IllegalStateException(String.format("@%s annotaion not found on data provider method %s", DataProvider.class.getSimpleName(), dataProviderMethod.getName()));
            }
            this.testValidator.validateDataProviderMethod(dataProviderMethod, dataProvider, errors);
        }
    }

    protected List<FrameworkMethod> computeTestMethods() {
        if (this.computedTestMethods == null) {
            this.computedTestMethods = this.generateExplodedTestMethodsFor(super.computeTestMethods());
        }
        return this.computedTestMethods;
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        super.filter((Filter)new DataProviderFilter(filter));
    }

    TestClass getTestClassInt() {
        return this.getTestClass();
    }

    List<FrameworkMethod> generateExplodedTestMethodsFor(List<FrameworkMethod> testMethods) {
        ArrayList<FrameworkMethod> result = new ArrayList<FrameworkMethod>();
        if (testMethods == null) {
            return result;
        }
        for (FrameworkMethod testMethod : testMethods) {
            FrameworkMethod dataProviderMethod = this.getDataProviderMethod(testMethod);
            result.addAll(this.testGenerator.generateExplodedTestMethodsFor(testMethod, dataProviderMethod));
        }
        return result;
    }

    FrameworkMethod getDataProviderMethod(FrameworkMethod testMethod) {
        if (testMethod == null) {
            throw new IllegalArgumentException("testMethod must not be null");
        }
        UseDataProvider useDataProvider = (UseDataProvider)testMethod.getAnnotation(UseDataProvider.class);
        if (useDataProvider == null) {
            return null;
        }
        TestClass dataProviderLocation = this.findDataProviderLocation(useDataProvider);
        for (FrameworkMethod method : dataProviderLocation.getAnnotatedMethods(DataProvider.class)) {
            if (!method.getName().equals(useDataProvider.value())) continue;
            return method;
        }
        return null;
    }

    TestClass findDataProviderLocation(UseDataProvider useDataProvider) {
        if (useDataProvider.location().length == 0) {
            return this.getTestClassInt();
        }
        return new TestClass(useDataProvider.location()[0]);
    }
}

