/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider.internal.placeholder;

import com.tngtech.java.junit.dataprovider.internal.placeholder.BasePlaceholder;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;

public class ParameterPlaceholder
extends BasePlaceholder {
    static final String STRING_NULL = "<null>";
    static final String STRING_EMPTY = "<empty string>";
    static final String STRING_NON_PRINTABLE = "<np>";

    public ParameterPlaceholder() {
        super("%p\\[(-?[0-9]+|-?[0-9]+\\.\\.-?[0-9]+)\\]");
    }

    @Override
    protected String getReplacementFor(String placeholder) {
        String subscript = placeholder.substring(3, placeholder.length() - 1);
        int from = Integer.MAX_VALUE;
        int to = Integer.MIN_VALUE;
        if (subscript.contains("..")) {
            String[] split = subscript.split("\\.\\.");
            from = Integer.parseInt(split[0]);
            to = Integer.parseInt(split[1]);
        } else {
            to = from = Integer.parseInt(subscript);
        }
        from = from >= 0 ? from : this.parameters.length + from;
        to = to >= 0 ? to + 1 : this.parameters.length + to + 1;
        return this.formatAll(Arrays.copyOfRange(this.parameters, from, to));
    }

    protected String formatAll(Object[] parameters) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < parameters.length; ++i) {
            stringBuilder.append(this.format(parameters[i]));
            if (i >= parameters.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    protected String format(Object param) {
        if (param == null) {
            return STRING_NULL;
        }
        if (param.getClass().isArray()) {
            if (param.getClass().getComponentType().isPrimitive()) {
                return this.formatPrimitiveArray(param);
            }
            return "[" + this.formatAll((Object[])param) + "]";
        }
        if (param instanceof String && ((String)param).isEmpty()) {
            return STRING_EMPTY;
        }
        String result = param instanceof String ? (String)param : param.toString();
        if (result == null) {
            return STRING_NULL;
        }
        result = result.replaceAll("\u0000", "\\\\0").replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n");
        return this.replaceNonPrintableChars(result, STRING_NON_PRINTABLE);
    }

    private String formatPrimitiveArray(Object primitiveArray) {
        Class<?> componentType = primitiveArray.getClass().getComponentType();
        if (Boolean.TYPE.equals(componentType)) {
            return Arrays.toString((boolean[])primitiveArray);
        }
        if (Byte.TYPE.equals(componentType)) {
            return Arrays.toString((byte[])primitiveArray);
        }
        if (Character.TYPE.equals(componentType)) {
            return Arrays.toString((char[])primitiveArray);
        }
        if (Short.TYPE.equals(componentType)) {
            return Arrays.toString((short[])primitiveArray);
        }
        if (Integer.TYPE.equals(componentType)) {
            return Arrays.toString((int[])primitiveArray);
        }
        if (Long.TYPE.equals(componentType)) {
            return Arrays.toString((long[])primitiveArray);
        }
        if (Float.TYPE.equals(componentType)) {
            return Arrays.toString((float[])primitiveArray);
        }
        if (Double.TYPE.equals(componentType)) {
            return Arrays.toString((double[])primitiveArray);
        }
        return "";
    }

    private String replaceNonPrintableChars(String input, String replacement) {
        int codePoint;
        StringBuilder result = new StringBuilder();
        block3: for (int offset = 0; offset < input.length(); offset += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(offset);
            switch (Character.getType(codePoint)) {
                case 0: 
                case 15: 
                case 16: 
                case 18: 
                case 19: {
                    result.append(replacement);
                    continue block3;
                }
            }
            result.append(Character.toChars(codePoint));
        }
        return result.toString();
    }
}

