/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider;

import com.tngtech.java.junit.dataprovider.Placeholders;
import com.tngtech.java.junit.dataprovider.internal.placeholder.BasePlaceholder;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.junit.runners.model.FrameworkMethod;

public class DataProviderFrameworkMethod
extends FrameworkMethod {
    final int idx;
    final Object[] parameters;
    final String nameFormat;

    public DataProviderFrameworkMethod(Method method, int idx, Object[] parameters, String nameFormat) {
        super(method);
        if (parameters == null) {
            throw new NullPointerException("parameter must not be null");
        }
        if (nameFormat == null) {
            throw new NullPointerException("nameFormat must not be null");
        }
        if (parameters.length == 0) {
            throw new IllegalArgumentException("parameter must not be empty");
        }
        this.idx = idx;
        this.parameters = Arrays.copyOf(parameters, parameters.length);
        this.nameFormat = nameFormat;
    }

    public String getName() {
        String result = this.nameFormat;
        for (BasePlaceholder placeHolder : Placeholders.all()) {
            placeHolder.setContext(this.getMethod(), this.idx, Arrays.copyOf(this.parameters, this.parameters.length));
            result = placeHolder.process(result);
        }
        return result;
    }

    public Object invokeExplosively(Object target, Object ... params) throws Throwable {
        return super.invokeExplosively(target, this.parameters);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.idx;
        result = 31 * result + (this.nameFormat == null ? 0 : this.nameFormat.hashCode());
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DataProviderFrameworkMethod other = (DataProviderFrameworkMethod)((Object)obj);
        if (this.idx != other.idx) {
            return false;
        }
        if (this.nameFormat == null ? other.nameFormat != null : !this.nameFormat.equals(other.nameFormat)) {
            return false;
        }
        return Arrays.equals(this.parameters, other.parameters);
    }
}

