/*
 * Decompiled with CFR 0.152.
 */
package com.titusfortner.logging;

import com.titusfortner.logging.DriverLogger;
import org.openqa.selenium.ie.InternetExplorerDriverLogLevel;

public class InternetExplorerDriverLogger
extends DriverLogger {
    public static InternetExplorerDriverLogger enable() {
        InternetExplorerDriverLogger logger = new InternetExplorerDriverLogger();
        logger.ensureEnabled();
        return logger;
    }

    public static InternetExplorerDriverLogger all() {
        InternetExplorerDriverLogger logger = new InternetExplorerDriverLogger();
        logger.setLevel(InternetExplorerDriverLogLevel.TRACE);
        return logger;
    }

    public void setLevel(InternetExplorerDriverLogLevel level) {
        System.setProperty(this.getLogLevelProperty(), level.name());
        this.ensureOutput();
    }

    public InternetExplorerDriverLogLevel getLevel() {
        String logLevel = System.getProperty(this.getLogLevelProperty());
        return logLevel == null ? null : InternetExplorerDriverLogLevel.valueOf((String)logLevel);
    }

    @Override
    protected void ensureLevel() {
        if (this.getLevel() == null) {
            this.setLevel(InternetExplorerDriverLogLevel.INFO);
        }
    }

    @Override
    protected String getLogProperty() {
        return "webdriver.ie.driver.logfile";
    }

    private String getLogLevelProperty() {
        return "webdriver.ie.driver.loglevel";
    }
}

