/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.app;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.SystemClock;
import com.tencent.tinker.loader.TinkerLoader;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.TinkerUncaughtHandler;
import com.tencent.tinker.loader.hotplug.ComponentHotplug;
import com.tencent.tinker.loader.hotplug.UnsupportedEnvironmentException;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public abstract class TinkerApplication
extends Application {
    private static final int TINKER_DISABLE = 0;
    private static final String INTENT_PATCH_EXCEPTION = "intent_patch_exception";
    private static final String TINKER_LOADER_METHOD = "tryLoad";
    private final int tinkerFlags;
    private final boolean tinkerLoadVerifyFlag;
    private final String delegateClassName;
    private final String loaderClassName;
    private boolean useSafeMode;
    private Intent tinkerResultIntent;
    private Object applicationLike = null;
    private long applicationStartElapsedTime;
    private long applicationStartMillisTime;

    protected TinkerApplication(int tinkerFlags) {
        this(tinkerFlags, "com.tencent.tinker.entry.DefaultApplicationLike", TinkerLoader.class.getName(), false);
    }

    protected TinkerApplication(int tinkerFlags, String delegateClassName, String loaderClassName, boolean tinkerLoadVerifyFlag) {
        this.tinkerFlags = tinkerFlags;
        this.delegateClassName = delegateClassName;
        this.loaderClassName = loaderClassName;
        this.tinkerLoadVerifyFlag = tinkerLoadVerifyFlag;
    }

    protected TinkerApplication(int tinkerFlags, String delegateClassName) {
        this(tinkerFlags, delegateClassName, TinkerLoader.class.getName(), false);
    }

    private Object createDelegate() {
        try {
            Class<?> delegateClass = Class.forName(this.delegateClassName, false, this.getClassLoader());
            Constructor<?> constructor = delegateClass.getConstructor(Application.class, Integer.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Intent.class);
            return constructor.newInstance(new Object[]{this, this.tinkerFlags, this.tinkerLoadVerifyFlag, this.applicationStartElapsedTime, this.applicationStartMillisTime, this.tinkerResultIntent});
        }
        catch (Throwable e) {
            throw new TinkerRuntimeException("createDelegate failed", e);
        }
    }

    private synchronized void ensureDelegate() {
        if (this.applicationLike == null) {
            this.applicationLike = this.createDelegate();
        }
    }

    private void onBaseContextAttached(Context base) {
        try {
            this.applicationStartElapsedTime = SystemClock.elapsedRealtime();
            this.applicationStartMillisTime = System.currentTimeMillis();
            this.loadTinker();
            this.ensureDelegate();
            ShareReflectUtil.findMethod(this.applicationLike, "onBaseContextAttached", Context.class).invoke(this.applicationLike, base);
            if (this.useSafeMode) {
                ShareTinkerInternals.setSafeModeCount((Context)this, 0);
            }
        }
        catch (TinkerRuntimeException e) {
            throw e;
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException(thr.getMessage(), thr);
        }
    }

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        Thread.setDefaultUncaughtExceptionHandler(new TinkerUncaughtHandler((Context)this));
        this.onBaseContextAttached(base);
    }

    private void loadTinker() {
        try {
            Class<?> tinkerLoadClass = Class.forName(this.loaderClassName, false, this.getClassLoader());
            Method loadMethod = tinkerLoadClass.getMethod(TINKER_LOADER_METHOD, TinkerApplication.class);
            Constructor<?> constructor = tinkerLoadClass.getConstructor(new Class[0]);
            this.tinkerResultIntent = (Intent)loadMethod.invoke(constructor.newInstance(new Object[0]), new Object[]{this});
        }
        catch (Throwable e) {
            this.tinkerResultIntent = new Intent();
            ShareIntentUtil.setIntentReturnCode(this.tinkerResultIntent, -20);
            this.tinkerResultIntent.putExtra(INTENT_PATCH_EXCEPTION, (Serializable)e);
        }
    }

    public void onCreate() {
        super.onCreate();
        try {
            this.ensureDelegate();
            try {
                ComponentHotplug.ensureComponentHotplugInstalled(this);
            }
            catch (UnsupportedEnvironmentException e) {
                throw new TinkerRuntimeException("failed to make sure that ComponentHotplug logic is fine.", e);
            }
            ShareReflectUtil.findMethod(this.applicationLike, "onCreate", new Class[0]).invoke(this.applicationLike, new Object[0]);
        }
        catch (TinkerRuntimeException e) {
            throw e;
        }
        catch (Throwable thr) {
            throw new TinkerRuntimeException(thr.getMessage(), thr);
        }
    }

    public void onTerminate() {
        super.onTerminate();
        if (this.applicationLike != null) {
            try {
                ShareReflectUtil.findMethod(this.applicationLike, "onTerminate", new Class[0]).invoke(this.applicationLike, new Object[0]);
            }
            catch (Throwable thr) {
                throw new TinkerRuntimeException(thr.getMessage(), thr);
            }
        }
    }

    public void onLowMemory() {
        super.onLowMemory();
        if (this.applicationLike != null) {
            try {
                ShareReflectUtil.findMethod(this.applicationLike, "onLowMemory", new Class[0]).invoke(this.applicationLike, new Object[0]);
            }
            catch (Throwable thr) {
                throw new TinkerRuntimeException(thr.getMessage(), thr);
            }
        }
    }

    @TargetApi(value=14)
    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        if (this.applicationLike != null) {
            try {
                ShareReflectUtil.findMethod(this.applicationLike, "onTrimMemory", Integer.TYPE).invoke(this.applicationLike, level);
            }
            catch (Throwable thr) {
                throw new TinkerRuntimeException(thr.getMessage(), thr);
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.applicationLike != null) {
            try {
                ShareReflectUtil.findMethod(this.applicationLike, "onConfigurationChanged", Configuration.class).invoke(this.applicationLike, newConfig);
            }
            catch (Throwable thr) {
                throw new TinkerRuntimeException(thr.getMessage(), thr);
            }
        }
    }

    public Resources getResources() {
        Resources resources = super.getResources();
        if (this.applicationLike != null) {
            try {
                return (Resources)ShareReflectUtil.findMethod(this.applicationLike, "getResources", Resources.class).invoke(this.applicationLike, resources);
            }
            catch (Throwable thr) {
                throw new TinkerRuntimeException(thr.getMessage(), thr);
            }
        }
        return resources;
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = super.getClassLoader();
        if (this.applicationLike != null) {
            try {
                return (ClassLoader)ShareReflectUtil.findMethod(this.applicationLike, "getClassLoader", ClassLoader.class).invoke(this.applicationLike, classLoader);
            }
            catch (Throwable thr) {
                throw new TinkerRuntimeException(thr.getMessage(), thr);
            }
        }
        return classLoader;
    }

    public AssetManager getAssets() {
        AssetManager assetManager = super.getAssets();
        if (this.applicationLike != null) {
            try {
                return (AssetManager)ShareReflectUtil.findMethod(this.applicationLike, "getAssets", AssetManager.class).invoke(this.applicationLike, assetManager);
            }
            catch (Throwable thr) {
                throw new TinkerRuntimeException(thr.getMessage(), thr);
            }
        }
        return assetManager;
    }

    public Object getSystemService(String name) {
        Object service = super.getSystemService(name);
        if (this.applicationLike != null) {
            try {
                return ShareReflectUtil.findMethod(this.applicationLike, "getSystemService", String.class, Object.class).invoke(this.applicationLike, name, service);
            }
            catch (Throwable thr) {
                throw new TinkerRuntimeException(thr.getMessage(), thr);
            }
        }
        return service;
    }

    public Context getBaseContext() {
        Context base = super.getBaseContext();
        if (this.applicationLike != null) {
            try {
                return (Context)ShareReflectUtil.findMethod(this.applicationLike, "getBaseContext", Context.class).invoke(this.applicationLike, base);
            }
            catch (Throwable thr) {
                throw new TinkerRuntimeException(thr.getMessage(), thr);
            }
        }
        return base;
    }

    public void setUseSafeMode(boolean useSafeMode) {
        this.useSafeMode = useSafeMode;
    }

    public boolean isTinkerLoadVerifyFlag() {
        return this.tinkerLoadVerifyFlag;
    }

    public int getTinkerFlags() {
        return this.tinkerFlags;
    }
}

