/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Build;
import android.util.ArrayMap;
import android.util.Log;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class TinkerResourcePatcher {
    private static final String TAG = "Tinker.ResourcePatcher";
    private static final String TEST_ASSETS_VALUE = "only_use_to_test_tinker_resource.txt";
    private static Collection<WeakReference<Resources>> references = null;
    private static Object currentActivityThread = null;
    private static AssetManager newAssetManager = null;
    private static Method addAssetPathMethod = null;
    private static Method ensureStringBlocksMethod = null;
    private static Field assetsFiled = null;
    private static Field resourcesImplFiled = null;
    private static Field resDir = null;
    private static Field packagesFiled = null;
    private static Field resourcePackagesFiled = null;
    private static Field publicSourceDirField = null;
    private static Field stringBlocksField = null;

    TinkerResourcePatcher() {
    }

    public static void isResourceCanPatch(Context context) throws Throwable {
        Class<?> loadedApkClass;
        Class<?> activityThread = Class.forName("android.app.ActivityThread");
        currentActivityThread = ShareReflectUtil.getActivityThread(context, activityThread);
        try {
            loadedApkClass = Class.forName("android.app.LoadedApk");
        }
        catch (ClassNotFoundException e) {
            loadedApkClass = Class.forName("android.app.ActivityThread$PackageInfo");
        }
        resDir = ShareReflectUtil.findField(loadedApkClass, "mResDir");
        packagesFiled = ShareReflectUtil.findField(activityThread, "mPackages");
        if (Build.VERSION.SDK_INT < 27) {
            resourcePackagesFiled = ShareReflectUtil.findField(activityThread, "mResourcePackages");
        }
        AssetManager assets = context.getAssets();
        addAssetPathMethod = ShareReflectUtil.findMethod(assets, "addAssetPath", String.class);
        try {
            stringBlocksField = ShareReflectUtil.findField(assets, "mStringBlocks");
            ensureStringBlocksMethod = ShareReflectUtil.findMethod(assets, "ensureStringBlocks", new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        newAssetManager = (AssetManager)ShareReflectUtil.findConstructor(assets, new Class[0]).newInstance(new Object[0]);
        if (Build.VERSION.SDK_INT >= 19) {
            Class<?> resourcesManagerClass = Class.forName("android.app.ResourcesManager");
            Method mGetInstance = ShareReflectUtil.findMethod(resourcesManagerClass, "getInstance", new Class[0]);
            Object resourcesManager = mGetInstance.invoke(null, new Object[0]);
            try {
                Field fMActiveResources = ShareReflectUtil.findField(resourcesManagerClass, "mActiveResources");
                ArrayMap activeResources19 = (ArrayMap)fMActiveResources.get(resourcesManager);
                references = activeResources19.values();
            }
            catch (NoSuchFieldException ignore) {
                Field mResourceReferences = ShareReflectUtil.findField(resourcesManagerClass, "mResourceReferences");
                references = (Collection)mResourceReferences.get(resourcesManager);
            }
        } else {
            Field fMActiveResources = ShareReflectUtil.findField(activityThread, "mActiveResources");
            HashMap activeResources7 = (HashMap)fMActiveResources.get(currentActivityThread);
            references = activeResources7.values();
        }
        if (references == null) {
            throw new IllegalStateException("resource references is null");
        }
        Resources resources = context.getResources();
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                resourcesImplFiled = ShareReflectUtil.findField(resources, "mResourcesImpl");
            }
            catch (Throwable ignore) {
                assetsFiled = ShareReflectUtil.findField(resources, "mAssets");
            }
        } else {
            assetsFiled = ShareReflectUtil.findField(resources, "mAssets");
        }
        try {
            publicSourceDirField = ShareReflectUtil.findField(ApplicationInfo.class, "publicSourceDir");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public static void monkeyPatchExistingResources(Context context, String externalResourceFile) throws Throwable {
        if (externalResourceFile == null) {
            return;
        }
        ApplicationInfo appInfo = context.getApplicationInfo();
        Field[] packagesFields = Build.VERSION.SDK_INT < 27 ? new Field[]{packagesFiled, resourcePackagesFiled} : new Field[]{packagesFiled};
        for (Field field : packagesFields) {
            Object value = field.get(currentActivityThread);
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String resDirPath;
                Object loadedApk = ((WeakReference)entry.getValue()).get();
                if (loadedApk == null || !appInfo.sourceDir.equals(resDirPath = (String)resDir.get(loadedApk))) continue;
                resDir.set(loadedApk, externalResourceFile);
            }
        }
        if ((Integer)addAssetPathMethod.invoke((Object)newAssetManager, externalResourceFile) == 0) {
            throw new IllegalStateException("Could not create new AssetManager");
        }
        if (stringBlocksField != null && ensureStringBlocksMethod != null) {
            stringBlocksField.set(newAssetManager, null);
            ensureStringBlocksMethod.invoke((Object)newAssetManager, new Object[0]);
        }
        for (WeakReference weakReference : references) {
            Resources resources = (Resources)weakReference.get();
            if (resources == null) continue;
            try {
                assetsFiled.set(resources, newAssetManager);
            }
            catch (Throwable ignore) {
                Object resourceImpl = resourcesImplFiled.get(resources);
                Field implAssets = ShareReflectUtil.findField(resourceImpl, "mAssets");
                implAssets.set(resourceImpl, newAssetManager);
            }
            TinkerResourcePatcher.clearPreloadTypedArrayIssue(resources);
            resources.updateConfiguration(resources.getConfiguration(), resources.getDisplayMetrics());
        }
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                if (publicSourceDirField != null) {
                    publicSourceDirField.set(context.getApplicationInfo(), externalResourceFile);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!TinkerResourcePatcher.checkResUpdate(context)) {
            throw new TinkerRuntimeException("checkResInstall failed");
        }
    }

    private static void clearPreloadTypedArrayIssue(Resources resources) {
        Log.w((String)TAG, (String)"try to clear typedArray cache!");
        try {
            Field typedArrayPoolField = ShareReflectUtil.findField(Resources.class, "mTypedArrayPool");
            Object origTypedArrayPool = typedArrayPoolField.get(resources);
            Method acquireMethod = ShareReflectUtil.findMethod(origTypedArrayPool, "acquire", new Class[0]);
            while (acquireMethod.invoke(origTypedArrayPool, new Object[0]) != null) {
            }
        }
        catch (Throwable ignored) {
            Log.e((String)TAG, (String)("clearPreloadTypedArrayIssue failed, ignore error: " + ignored));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkResUpdate(Context context) {
        InputStream is = null;
        try {
            is = context.getAssets().open(TEST_ASSETS_VALUE);
        }
        catch (Throwable e) {
            boolean bl;
            try {
                Log.e((String)TAG, (String)("checkResUpdate failed, can't find test resource assets file only_use_to_test_tinker_resource.txt e:" + e.getMessage()));
                bl = false;
            }
            catch (Throwable throwable) {
                SharePatchFileUtil.closeQuietly(is);
                throw throwable;
            }
            SharePatchFileUtil.closeQuietly(is);
            return bl;
        }
        SharePatchFileUtil.closeQuietly(is);
        Log.i((String)TAG, (String)"checkResUpdate success, found test resource assets file only_use_to_test_tinker_resource.txt");
        return true;
    }
}

